package csbase.logic.algorithms.flows;

import java.io.Serializable;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.LNG;

/**
 * <p>
 * Parmetro de n.
 * </p>
 * 
 * @author lmoreira
 */
public final class NodeParameter implements Serializable, Cloneable {

  /**
   * O rtulo.
   */
  private String label;

  /**
   * O nome.
   */
  private String name;

  /**
   * O tipo.
   */
  private String type;

  /**
   * O valor.
   */
  private String value;

  /**
   * Cria um parmetro de n.
   * 
   * @param name O nome (No aceita {@code null}).
   * @param label O rtulo (No aceita {@code null}).
   * @param type O tipo (No aceita {@code null}).
   * @param value O valor (Aceita {@code null}).
   */
  public NodeParameter(String name, String label, String type, String value) {
    setName(name);
    setLabel(label);
    setType(type);
    setValue(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public NodeParameter clone() {
    try {
      return (NodeParameter) super.clone();
    }
    catch (CloneNotSupportedException e) {
      throw new IllegalStateException(e);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    NodeParameter other = (NodeParameter) obj;
    if (!getName().equals(other.getName())) {
      return false;
    }
    return true;
  }

  /**
   * Obtm o rtulo.
   * 
   * @return O rtulo.
   */
  public String getLabel() {
    return this.label;
  }

  /**
   * Obtm o nome.
   * 
   * @return O nome.
   */
  public String getName() {
    return this.name;
  }

  /**
   * Obtm o tipo.
   * 
   * @return O tipo.
   */
  public String getType() {
    return this.type;
  }

  /**
   * Obtm o valor.
   * 
   * @return O valor.
   */
  public String getValue() {
    return this.value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return getName().hashCode();
  }

  /**
   * Atribui um valor.
   * 
   * @param value O valor (Aceita {@code null}).
   */
  public void setValue(String value) {
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append("Nome:   " + getName() + "\n");
    builder.append("Rtulo: " + getLabel() + "\n");
    builder.append("Tipo:   " + getType() + "\n");
    builder.append("Valor:  " + getValue() + "\n");
    return builder.toString();
  }

  /**
   * Atribui o rtulo.
   * 
   * @param label O rtulo (No aceita {@code null}).
   */
  private void setLabel(String label) {
    if (label == null) {
      throw new IllegalArgumentException(
      	MessageFormat.format(LNG.get(
      		"csbase.logic.algorithms.nullParameter"),
      		"label"));
 }
    this.label = label;
  }

  /**
   * Atribui o nome.
   * 
   * @param name O nome (No aceita {@code null}).
   */
  private void setName(String name) {
    if (name == null) {
      throw new IllegalArgumentException(
	      	MessageFormat.format(LNG.get(
	      		"csbase.logic.algorithms.nullParameter"),
	      		"name"));
    }
    this.name = name;
  }

  /**
   * Atribui o tipo.
   * 
   * @param type O tipo (No aceita {@code null}).
   */
  private void setType(String type) {
    if (type == null) {
      throw new IllegalArgumentException(
      	MessageFormat.format(LNG.get(
      		"csbase.logic.algorithms.nullParameter"),
  			"O parmetro type est nulo."));
    }
    this.type = type;
  }

}
