/*
 * $Id$
 */
package csbase.logic.algorithms.parameters.conditions;

import java.text.MessageFormat;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import tecgraf.javautils.core.lng.LNG;

/**
 * Condio simples.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class SimpleCondition implements Condition {
  /**
   * Nome do parmetro
   */
  private final String parameterName;

  /**
   * Valor
   */
  private final Object value;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!getClass().equals(obj.getClass())) {
      return false;
    }
    final SimpleCondition condition = (SimpleCondition) obj;
    final String conditionParameterName = condition.getParameterName();
    if (!parameterName.equals(conditionParameterName)) {
      return false;
    }

    final Object conditionValue = condition.getValue();
    if (value == null && conditionValue == null) {
      return true;
    }
    if (value != null && value.equals(conditionValue)) {
      return true;
    }
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean evaluate(final SimpleAlgorithmConfigurator configurator) {
    if (configurator == null) {
      final String err = MessageFormat.format(LNG.get(
    		  "csbase.logic.algorithms.nullParameter"),
    		  "version");
      throw new IllegalArgumentException(err);
    }
    final SimpleParameter<?> parameter =
      configurator.getSimpleParameter(parameterName);
    if (parameter == null) {
      final String fmt = LNG.get(
    		  "csbase.logic.algorithms.parameters.CompositeOperatorCondition");
      final String err =
    		  MessageFormat.format(fmt, parameterName, configurator);
      throw new IllegalStateException(err);
    }

    final Object currentValue = parameter.getValue();
    if (this.value == null && currentValue == null) {
      return true;
    }
    if (this.value != null && this.value.equals(currentValue)) {
      return true;
    }
    return false;
  }

  /**
   * Consulta o nome do parmetro
   * 
   * @return o nome
   */
  public String getParameterName() {
    return this.parameterName;
  }

  /**
   * Consulta o valor do parmetro
   * 
   * @return o valor
   */
  public Object getValue() {
    return this.value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return parameterName.hashCode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String toString = "----------\n";
    toString += "Classe = " + getClass().getName() + "\n";
    toString += "Parametro = " + getParameterName() + "\n";
    toString += "Valor = " + getValue() + "\n";
    toString += "----------\n";
    return toString;
  }

  /**
   * Construtor
   * 
   * @param parameterName nome do parmetro
   * @param value valor do parmetro.
   */
  public SimpleCondition(final String parameterName, final Object value) {
    if (parameterName == null) {
      throw new IllegalArgumentException(MessageFormat.format(LNG.get(
    		  "csbase.logic.algorithms.nullParameter"),
    		  "parameterName"));
    }
    this.parameterName = parameterName;
    this.value = value;
  }
}
