/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters.validators;

import java.text.MessageFormat;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationSuccess;
import tecgraf.javautils.core.lng.LNG;

/**
 * Validador de {@link csbase.logic.algorithms.parameters.BooleanParameter
 * Parmetro do Tipo Booleano}.
 * 
 * @author lmoreira
 */
public final class BooleanParameterValidator extends
  SimpleParameterValidator<Boolean> {
  /**
   * Cria um Validador.
   */
  public BooleanParameterValidator() {
    super(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Validation validateValue(SimpleParameter<?> parameter, Boolean value,
    ValidationContext context) {
    if (parameter == null) {
      throw new IllegalArgumentException(MessageFormat.format(LNG.get(
    		  "csbase.logic.algorithms.nullParameter"),
    		  "parameter"));
    }
    if (value == null) {
      throw new IllegalArgumentException(MessageFormat.format(LNG.get(
    		  "csbase.logic.algorithms.nullParameter"),
    		  "value"));
    }
    return new ValidationSuccess();
  }
}
