package csbase.logic.algorithms.parsers;

import java.util.Collections;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.TextListParameter;

/**
 * <p>
 * Analisador de {@link TextListParameter}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "lista de textos". O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link TextListParameter}.
 * </p>
 */
public class TextListParameterFactory extends
  AbstractTextParameterParser<TextListParameter> {

  /**
   * {@inheritDoc}
   */
  @Override
  protected TextListParameter createTextParameter(XmlParser parser,
    String name, String label, String description, boolean isOptional,
    boolean isVisible, String commandLinePattern, Integer maxCharacters)
    throws ParseException {
    return new TextListParameter(name, label, description, null, isOptional,
      isVisible, commandLinePattern, maxCharacters);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    return Collections.singletonList(TextListParameter.class);
  }
}
