package csbase.logic.projectservice;

import csbase.logic.ProjectFileInfo;

/**
 * Define um template de projeto a partir de um diretrio-base sem restries.
 */
public class BasicProjectTemplate implements ProjectTemplate {

  /**
   * Direttio-base do template.
   */
  private final ProjectFileInfo baseDir;

  /**
   * Parmetros para configurao do template.
   */
  private String[] parameters;

  /**
   * Construtor.
   *
   * @param baseDir diretrio-base do template.
   * @param params parmetros para configurao do template.
   */
  public BasicProjectTemplate(ProjectFileInfo baseDir, String... params) {
    this.baseDir = baseDir;
    this.parameters = params;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canRename(ProjectFileInfo file, String newName) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canDelete(ProjectFileInfo file) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canCreate(ProjectFileInfo parentDir, String name, String type) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canChangeType(ProjectFileInfo file, String newType) {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectFileInfo getBaseDir() {
    return baseDir;
  }

  /**
   * Obtm os parmetros do template.
   *
   * @return os parmetros.
   */
  public String[] getParameters() {
    return parameters;
  }
}
