/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CapacityType;
import csbase.logic.MonitoringSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class SGAInfo
implements MonitoringSet,
Comparable<SGAInfo> {
    public static final int ALL_CAPACITY = -2;
    public static final int NO_CAPACITY = -1;
    public static final int CALC_CAPACITY = 0;
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private char fileSeparator;
    private String[] projectRootDirectory;
    private String[] algorithmRootDirectory;
    private String[] sandboxRootDirectory;
    private String hostName;
    private String platformId;
    private int numProcessors;
    private int memoryRamInfoMb;
    private int memorySwapInfoMb;
    private int clockSpeedMHz;
    private double hostRAMFreeMemory;
    private double hostSwapFreeMemory;
    private int numberOfJobs;
    private double hostLoadAvg1;
    private Hashtable<CapacityType, Long> capacities;
    private Map<String, String> properties;
    private double hostLoadAvg5;
    private double hostLoadAvg15;
    private boolean alive;
    private Set<String> requirements;

    public void addRequirement(String requirement) {
        this.requirements.add(requirement.trim().toUpperCase());
    }

    public boolean hasRequirement(String requirement) {
        return this.requirements.contains(requirement.trim().toUpperCase());
    }

    public Set<String> getRequirements() {
        return Collections.unmodifiableSet(this.requirements);
    }

    @Override
    public int compareTo(SGAInfo sgaInfo) {
        return this.toString().compareTo(sgaInfo.toString());
    }

    public double getCPULoad1() {
        return this.hostLoadAvg1;
    }

    public double getCPULoad5() {
        return this.hostLoadAvg5;
    }

    public double getCPULoad15() {
        return this.hostLoadAvg15;
    }

    public double getRAMFreeMemory() {
        return this.hostRAMFreeMemory;
    }

    public double getRAMFreeMemoryMb() {
        return this.hostRAMFreeMemory * ((double)this.memoryRamInfoMb / 100.0);
    }

    public double getSwapFreeMemory() {
        return this.hostSwapFreeMemory;
    }

    public int getNumberOfJobs() {
        return this.numberOfJobs;
    }

    public String[] getProjectRootDirectory() {
        return this.projectRootDirectory;
    }

    public String[] getAlgorithmRootDirectory() {
        return this.algorithmRootDirectory;
    }

    public String[] getSandboxRootDirectory() {
        return this.sandboxRootDirectory;
    }

    public char getFileSeparator() {
        return this.fileSeparator;
    }

    public String toString() {
        return this.getHostName();
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public boolean getAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
        if (!alive) {
            this.setRAMFreeMemory(0.0);
            this.setSwapFreeMemory(0.0);
            this.setCPULoad(0.0, 0.0, 0.0);
        }
    }

    public void addCapacities(CapacityType type, long value) {
        this.capacities.put(type, value);
    }

    public long getCapacity(CapacityType capacity) {
        if (this.capacities.containsKey((Object)capacity)) {
            return this.capacities.get((Object)capacity);
        }
        return -1L;
    }

    public int getNumProcessors() {
        return this.numProcessors;
    }

    public int getRAMMemoryInfoMb() {
        return this.memoryRamInfoMb;
    }

    public int getSwapMemoryInfoMb() {
        return this.memorySwapInfoMb;
    }

    public int getClockSpeedMHz() {
        return this.clockSpeedMHz;
    }

    public void setCPULoad(double hostLoadAvg1, double hostLoadAvg5, double hostLoadAvg15) {
        this.hostLoadAvg1 = hostLoadAvg1;
        this.hostLoadAvg5 = hostLoadAvg5;
        this.hostLoadAvg15 = hostLoadAvg15;
    }

    public void setRAMFreeMemory(double hostRAMFreeMemory) {
        this.hostRAMFreeMemory = hostRAMFreeMemory;
    }

    public void setNumberOfJobs(int numberOfJobs) {
        this.numberOfJobs = numberOfJobs;
    }

    public void setSwapFreeMemory(double hostSwapFreeMemory) {
        this.hostSwapFreeMemory = hostSwapFreeMemory;
    }

    public void setTransferRate(long transferRate) {
        this.capacities.put(CapacityType.NET, transferRate);
    }

    @Override
    public boolean equals(MonitoringSet o) {
        if (!(o instanceof SGAInfo)) {
            return false;
        }
        SGAInfo other = (SGAInfo)o;
        if (!this.getHostName().equals(other.getHostName())) {
            return false;
        }
        if (this.getAlive() != other.getAlive()) {
            return false;
        }
        if (this.getCPULoad1() != other.getCPULoad1()) {
            return false;
        }
        if (this.getRAMMemoryInfoMb() != other.getRAMMemoryInfoMb()) {
            return false;
        }
        if (this.getSwapMemoryInfoMb() != other.getSwapMemoryInfoMb()) {
            return false;
        }
        return this.getPlatformId().equals(other.getPlatformId());
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getHostName());
        buffer.append(Boolean.toString(this.getAlive()));
        buffer.append(Double.toString(this.getCPULoad1()));
        buffer.append(Integer.toString(this.getRAMMemoryInfoMb()));
        buffer.append(Integer.toString(this.getSwapMemoryInfoMb()));
        buffer.append(this.getPlatformId());
        return buffer.toString().hashCode();
    }

    @Override
    public String getKey() {
        return this.getHostName();
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String[] getPropertiesKeys() {
        String[] keys = new String[this.properties.size()];
        this.properties.keySet().toArray(keys);
        return keys;
    }

    public SGAInfo(String hostName, String platformId, int numProcessors, int memoryRamInfoMb, int memorySwapInfoMb, int clockSpeedMHz, char fileSeparator, String[] projectRootDirectory, String[] algorithmRootDirectory, String[] sandboxRootDirectory, Map<String, String> properties) {
        this.hostName = hostName;
        this.platformId = platformId;
        this.numProcessors = numProcessors;
        this.memoryRamInfoMb = memoryRamInfoMb;
        this.memorySwapInfoMb = memorySwapInfoMb;
        this.clockSpeedMHz = clockSpeedMHz;
        this.fileSeparator = fileSeparator;
        this.projectRootDirectory = projectRootDirectory;
        this.algorithmRootDirectory = algorithmRootDirectory;
        this.sandboxRootDirectory = sandboxRootDirectory;
        this.hostRAMFreeMemory = -1.0;
        this.hostSwapFreeMemory = -1.0;
        this.hostLoadAvg1 = -1.0;
        this.hostLoadAvg5 = -1.0;
        this.hostLoadAvg15 = -1.0;
        this.numberOfJobs = -1;
        this.alive = false;
        this.requirements = new HashSet<String>();
        this.capacities = new Hashtable();
        this.properties = properties;
    }
}

