/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.RowValueListener;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class RowValue
implements Serializable {
    private List<Object> cellValues;
    private List<RowValueListener> listeners;

    public RowValue(Object ... cellValues) {
        if (cellValues == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "cellValues"));
        }
        this.cellValues = new ArrayList<Object>(cellValues.length);
        for (Object cellValue : cellValues) {
            this.cellValues.add(cellValue);
        }
        this.listeners = new LinkedList<RowValueListener>();
    }

    public void addRowValueListener(RowValueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    public Object getCellValue(int columnIndex) {
        return this.cellValues.get(columnIndex);
    }

    public boolean removeRowValueListener(RowValueListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        return this.listeners.remove(listener);
    }

    public void setCellValue(Object cellValue, int columnIndex) {
        this.cellValues.set(columnIndex, cellValue);
        for (RowValueListener listener : this.listeners) {
            listener.valueWasChanged(cellValue, columnIndex);
        }
    }

    public List<Object> getCellValues() {
        return Collections.unmodifiableList(this.cellValues);
    }
}

