/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public abstract class SimpleParameterValidator<V>
implements Serializable {
    private boolean isOptional;
    private ValidationMode mode;

    protected SimpleParameterValidator(boolean isOptional) {
        this.isOptional = isOptional;
        this.mode = ValidationMode.FULL;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        SimpleParameterValidator validator = (SimpleParameterValidator)obj;
        return this.isOptional() == validator.isOptional();
    }

    public int hashCode() {
        return new Boolean(this.isOptional()).hashCode();
    }

    public Validation validateValue(SimpleParameter<?> parameter, V value, ValidationContext context) throws RemoteException {
        if (parameter == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameter"));
        }
        if (parameter.isEnabled() && parameter.isVisible() && value == null) {
            if (this.isOptional() || this.getMode().equals((Object)ValidationMode.ALLOW_EMPY_VALUES)) {
                return new ValidationSuccess();
            }
            LocalizedMessage message = new LocalizedMessage(SimpleParameterValidator.class, "empty_value", new Object[]{parameter.getLabel()});
            return new ValidationError(message);
        }
        return new ValidationSuccess();
    }

    public final ValidationMode getMode() {
        return this.mode;
    }

    public void setMode(ValidationMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "this.mode"));
        }
        this.mode = mode;
    }

    public final boolean isOptional() {
        return this.isOptional;
    }

    public Object convert(Object itemValue) {
        return itemValue;
    }
}

