/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows;

import csbase.exception.BugException;
import csbase.exception.ConfigurationException;
import csbase.exception.ParseException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.NodeParameter;
import csbase.logic.algorithms.flows.Point;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.remote.AlgorithmServiceInterface;
import csbase.remote.ClientRemoteLocator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tecgraf.javautils.core.lng.LNG;

public final class FlowAlgorithmParser {
    private static final String ALGORITHM_ATTRIBUTE_NAME = "nome";
    private static final String ALGORITHM_ATTRIBUTE_LABEL = "rotulo";
    private static final String ALGORITHM_ATTRIBUTE_VERSION = "versao";
    private static final String ALGORITHM_ELEMENT_NAME = "algoritmo";
    private static final String ALGORITHM_ATTRIBUTE_ID = "id";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String FLOW_ELEMENT_NAME = "fluxo";
    private static final String FLOW_DESCRIPTION_NAME = "descricao";
    private static final String FLOW_ATTRIBUTE_NAME = "nome";
    private static final String INPUT_ELEMENT_NAME = "entrada";
    private static final String LINK_ATTRIBUTE_ID = "id";
    private static final String LINK_ELEMENT_NAME = "conexao";
    private static final String LINK_PARAMETER_ATTRIBUTE_LABEL = "rotulo";
    private static final String LINK_PARAMETER_ATTRIBUTE_NAME = "parametro";
    private static final String LINK_PARAMETER_ATTRIBUTE_NODE_ID = "no";
    private static final String NODE_ATTRIBUTE_ID = "id";
    private static final String NODE_ELEMENT_NAME = "no";
    private static final String NODE_PARAMETER_ATTRIBUTE_LABEL = "rotulo";
    private static final String NODE_PARAMETER_ATTRIBUTE_NAME = "nome";
    private static final String NODE_PARAMETER_ATTRIBUTE_TYPE = "tipo";
    private static final String NODE_PARAMETER_ATTRIBUTE_VALUE = "valor";
    private static final String NODE_PARAMETER_ELEMENT_NAME = "parametro";
    private static final String NODE_PARAMETER_VALUE_ELEMENT_NAME = "valor";
    private static final String NODE_STDOUT_ELEMENT_NAME = "stdout";
    private static final String NODE_STDOUT_ATTRIBUTE_TYPE = "tipo";
    private static final String NODE_EXIT_CODE_ELEMENT_NAME = "codigo_saida";
    private static final String NODE_EXIT_CODE_ATTRIBUTE_TYPE = "tipo";
    private static final int NUMBER_OF_SPACES_FOR_TABS = 3;
    private static final String OUTPUT_ELEMENT_NAME = "saida";
    private static final String POINT_ELEMENT_NAME = "ponto";
    private static final String POINT_X_ATTRIBUTE = "x";
    private static final String POINT_Y_ATTRIBUTE = "y";
    private static final String SIZE_ELEMENT_NAME = "tamanho";
    private static final String SIZE_HEIGHT_ATTRIBUTE = "altura";
    private static final String SIZE_WIDTH_ATTRIBUTE = "largura";
    private static final String BYPASSED_ELEMENT_NAME = "desviar";
    private static final String BYPASSED_ATTRIBUTE = "valor";
    private DocumentBuilder builder;
    private final Stack<String> elementNames = new Stack();

    public FlowAlgorithmParser() throws ConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setValidating(false);
            this.builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String errorMessage = LNG.get((String)"csbase.logic.algorithms.flows.FlowAlgorithmParser.configAnalysis");
            throw new ConfigurationException(e, errorMessage);
        }
    }

    public Flow read(InputStream inputStream) throws ParseException, IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream == null");
        }
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setEncoding(DEFAULT_ENCODING);
            Document document = this.builder.parse(inputSource);
            document.normalize();
            Element rootElement = document.getDocumentElement();
            String name = this.getAttributeValue(rootElement, "nome", true);
            String description = this.getAttributeValue(rootElement, FLOW_DESCRIPTION_NAME, true);
            Set<FlowNode> nodes = this.decodeNodes(rootElement);
            Set<FlowLink> links = this.decodeLinks(rootElement);
            Flow flow = new Flow(name, description, nodes, links);
            return flow;
        }
        catch (SAXException e) {
            Exception throwable = e.getException() != null ? e.getException() : e;
            String errorMessage = LNG.get((String)"csbase.logic.algorithms.flows.FlowAlgorithmParser.readingFile");
            throw new ParseException(throwable, errorMessage, new Object[0]);
        }
    }

    public void write(OutputStream outputStream, Flow flow) {
        String encoding = DEFAULT_ENCODING;
        this.write(outputStream, encoding, flow);
    }

    public void write(OutputStream outputStream, String encoding, Flow flow) {
        Charset charset = Charset.forName(encoding);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);
        PrintWriter printWriter = new PrintWriter(writer);
        this.write(printWriter, encoding, flow);
    }

    public Flow decode(String encodedFlow) throws ParseException {
        try {
            byte[] content = encodedFlow.getBytes(DEFAULT_ENCODING);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
            return this.read(inputStream);
        }
        catch (IOException e) {
            throw new BugException(e);
        }
    }

    public String encode(Flow flow) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.write(outputStream, DEFAULT_ENCODING, flow);
        byte[] content = outputStream.toByteArray();
        try {
            return new String(content, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new BugException(e);
        }
    }

    private Attr getAttribute(Element element, String attributeName, boolean isOptional) throws ParseException {
        NamedNodeMap nodeMap = element.getAttributes();
        Attr attribute = (Attr)nodeMap.getNamedItem(attributeName);
        if (attribute == null) {
            if (isOptional) {
                return null;
            }
            String elementName = element.getLocalName();
            String errorMessage = String.format(LNG.get((String)"csbase.logic.algorithms.flows.FlowAlgorithmParser.attributeNotFound"), elementName, attributeName);
            throw new ParseException(errorMessage);
        }
        return attribute;
    }

    private String getAttributeValue(Element element, String attributeName) throws ParseException {
        return this.getAttributeValue(element, attributeName, false);
    }

    private String getAttributeValue(Element element, String attributeName, boolean isOptional) throws ParseException {
        Attr attribute = this.getAttribute(element, attributeName, isOptional);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    private Element getChildElement(Element element, String elementName) throws ParseException {
        return this.getChildElement(element, elementName, false);
    }

    private Element getChildElement(Element element, String elementName, boolean isOptional) throws ParseException {
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element childElement;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !(childElement = (Element)childNode).getLocalName().equals(elementName)) continue;
            return childElement;
        }
        if (isOptional) {
            return null;
        }
        throw new ParseException(LNG.get((String)"csbase.logic.algorithms.flows.FlowAlgorithmParser.elementNotFound"), elementName);
    }

    private List<Element> getChildElements(Element element, String elementName) {
        LinkedList<Element> childElements = new LinkedList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element childElement;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1 || !(childElement = (Element)childNode).getLocalName().equals(elementName)) continue;
            childElements.add(childElement);
        }
        return Collections.unmodifiableList(childElements);
    }

    private String getElementValue(Element element) {
        if (element == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "element"));
        }
        String textContent = element.getTextContent();
        if (textContent == null) {
            return null;
        }
        if ((textContent = textContent.trim()).length() == 0) {
            return null;
        }
        return textContent;
    }

    private int getIntegerAttributeValue(Element element, String attributeName) throws ParseException {
        String attributeValue = this.getAttributeValue(element, attributeName);
        try {
            return Integer.parseInt(attributeValue);
        }
        catch (NumberFormatException e) {
            String elementName = element.getLocalName();
            String errorMessage = String.format(LNG.get((String)"csbase.logic.algorithms.flows.FlowAlgorithmParser.typeError"), elementName, attributeName, attributeValue);
            throw new ParseException(e, errorMessage, new Object[0]);
        }
    }

    private void indent(PrintWriter printWriter) {
        for (int i = 0; i < this.elementNames.size(); ++i) {
            for (int j = 0; j < 3; ++j) {
                printWriter.print(' ');
            }
        }
    }

    private FlowLink decodeLink(Element element) throws ParseException {
        int id = this.getIntegerAttributeValue(element, "id");
        Element outputElement = this.getChildElement(element, OUTPUT_ELEMENT_NAME, true);
        if (outputElement == null) {
            return null;
        }
        LinkParameter outputLinkParameter = this.decodeLinkParameter(outputElement);
        Element inputElement = this.getChildElement(element, INPUT_ELEMENT_NAME, true);
        if (inputElement == null) {
            return null;
        }
        LinkParameter inputLinkParameter = this.decodeLinkParameter(inputElement);
        List<Point> points = this.decodePoints(element);
        FlowLink link = new FlowLink(id, outputLinkParameter, inputLinkParameter, points);
        return link;
    }

    private LinkParameter decodeLinkParameter(Element element) throws ParseException {
        int nodeId = this.getIntegerAttributeValue(element, "no");
        String parameterName = this.getAttributeValue(element, "parametro");
        String parameterLabel = this.getAttributeValue(element, "rotulo");
        LinkParameter parameter = new LinkParameter(nodeId, parameterName, parameterLabel);
        return parameter;
    }

    private Set<FlowLink> decodeLinks(Element parentElement) throws ParseException {
        HashSet<FlowLink> links = new HashSet<FlowLink>();
        List<Element> elements = this.getChildElements(parentElement, LINK_ELEMENT_NAME);
        for (Element element : elements) {
            FlowLink link = this.decodeLink(element);
            if (link == null) continue;
            links.add(link);
        }
        return links;
    }

    private FlowNode decodeNode(Element element) throws ParseException, RemoteException {
        int id = this.getIntegerAttributeValue(element, "id");
        Element algorithmElement = this.getChildElement(element, ALGORITHM_ELEMENT_NAME);
        String algorithmName = this.getAttributeValue(algorithmElement, "nome");
        String algorithmModifiedName = this.getAttributeValue(algorithmElement, "rotulo", true);
        String algorithmId = this.getAttributeValue(algorithmElement, "id", true);
        String algorithmVersionIdAsText = this.getAttributeValue(algorithmElement, ALGORITHM_ATTRIBUTE_VERSION);
        AlgorithmVersionId algorithmVersionId = AlgorithmVersionId.create(algorithmVersionIdAsText);
        if (algorithmVersionId == null) {
            String errorMessage = String.format(LNG.get((String)"csbase.logic.algorithms.flows.FlowAlgorithmParser.invalidFormat"), algorithmVersionIdAsText);
            throw new ParseException(errorMessage);
        }
        Set<NodeParameter> parameters = this.decodeNodeParameters(algorithmElement);
        FileURLValue stdout = this.decodeNodeStandardOutput(algorithmElement);
        FileURLValue exitCode = this.decodeNodeExitCodeFile(algorithmElement);
        Element pointElement = this.getChildElement(element, POINT_ELEMENT_NAME);
        Point point = this.decodePoint(pointElement);
        Element sizeElement = this.getChildElement(element, SIZE_ELEMENT_NAME);
        int width = this.getIntegerAttributeValue(sizeElement, SIZE_WIDTH_ATTRIBUTE);
        int height = this.getIntegerAttributeValue(sizeElement, SIZE_HEIGHT_ATTRIBUTE);
        Boolean bypassed = false;
        try {
            AlgorithmConfigurator algorithmConfigurator;
            AlgorithmInfo info;
            Element bypasseElement = this.getChildElement(element, BYPASSED_ELEMENT_NAME);
            String bypassedString = this.getAttributeValue(bypasseElement, "valor");
            bypassed = Boolean.parseBoolean(bypassedString);
            AlgorithmServiceInterface algorithmService = this.getAlgorithmService();
            String name = algorithmName;
            if (algorithmId != null && (info = algorithmService.getInfo((Object)algorithmId)) != null) {
                name = info.getName();
            }
            if ((algorithmConfigurator = algorithmService.createAlgorithmConfigurator(name, algorithmVersionId)) != null) {
                algorithmConfigurator.setStandardOutputFile(stdout);
                algorithmConfigurator.setExitCodeLogFile(exitCode);
                if (exitCode != null) {
                    algorithmConfigurator.setHasExitCode(true);
                }
                try {
                    this.fillParameterValues(algorithmConfigurator, parameters);
                }
                catch (ParameterNotFoundException e) {
                    e.printStackTrace();
                }
                return new FlowNode(id, algorithmConfigurator, algorithmModifiedName, parameters, point.getX(), point.getY(), width, height, bypassed);
            }
            return new FlowNode(id, name, algorithmModifiedName, algorithmVersionId, parameters, point.getX(), point.getY(), width, height, bypassed, false);
        }
        catch (AlgorithmNotFoundException e) {
            return new FlowNode(id, algorithmName, algorithmModifiedName, algorithmVersionId, parameters, point.getX(), point.getY(), width, height, bypassed, false);
        }
        catch (ParseException e) {
            return new FlowNode(id, algorithmName, algorithmModifiedName, algorithmVersionId, parameters, point.getX(), point.getY(), width, height, bypassed, false);
        }
    }

    private void fillParameterValues(AlgorithmConfigurator configurator, Set<NodeParameter> parameters) throws ParseException, ParameterNotFoundException {
        HashMap<String, String> parameterValuesByName = new HashMap<String, String>();
        for (NodeParameter parameter : parameters) {
            parameterValuesByName.put(parameter.getName(), parameter.getValue());
        }
        configurator.setParameterValuesByName(parameterValuesByName);
    }

    private AlgorithmServiceInterface getAlgorithmService() {
        return ClientRemoteLocator.algorithmService;
    }

    private NodeParameter decodeNodeParameter(Element element) throws ParseException {
        Element childElement;
        String parameterName = this.getAttributeValue(element, "nome");
        String parameterLabel = this.getAttributeValue(element, "rotulo");
        String parameterType = this.getAttributeValue(element, "tipo");
        String parameterValue = this.getAttributeValue(element, "valor", true);
        if (parameterValue == null && (childElement = this.getChildElement(element, "valor", true)) != null) {
            parameterValue = this.getElementValue(childElement);
        }
        NodeParameter parameter = new NodeParameter(parameterName, parameterLabel, parameterType, parameterValue);
        return parameter;
    }

    private Set<NodeParameter> decodeNodeParameters(Element parentElement) throws ParseException {
        HashSet<NodeParameter> parameters = new HashSet<NodeParameter>();
        List<Element> elements = this.getChildElements(parentElement, "parametro");
        for (Element element : elements) {
            NodeParameter parameter = this.decodeNodeParameter(element);
            parameters.add(parameter);
        }
        return parameters;
    }

    private FileURLValue decodeNodeStandardOutput(Element parentElement) throws ParseException {
        Element stdoutElement = this.getChildElement(parentElement, NODE_STDOUT_ELEMENT_NAME, true);
        if (null == stdoutElement) {
            return null;
        }
        String path = this.getElementValue(stdoutElement);
        String type = this.getAttributeValue(stdoutElement, "tipo");
        return new FileURLValue(path, type);
    }

    private FileURLValue decodeNodeExitCodeFile(Element parentElement) throws ParseException {
        Element exitCodeElement = this.getChildElement(parentElement, NODE_EXIT_CODE_ELEMENT_NAME, true);
        if (null == exitCodeElement) {
            return null;
        }
        String path = this.getElementValue(exitCodeElement);
        String type = this.getAttributeValue(exitCodeElement, "tipo");
        return new FileURLValue(path, type);
    }

    private Set<FlowNode> decodeNodes(Element parentElement) throws ParseException, RemoteException {
        HashSet<FlowNode> nodes = new HashSet<FlowNode>();
        List<Element> elements = this.getChildElements(parentElement, "no");
        for (Element element : elements) {
            FlowNode node = this.decodeNode(element);
            nodes.add(node);
        }
        return nodes;
    }

    private Point decodePoint(Element element) throws ParseException {
        int x = this.getIntegerAttributeValue(element, POINT_X_ATTRIBUTE);
        int y = this.getIntegerAttributeValue(element, POINT_Y_ATTRIBUTE);
        Point point = new Point(x, y);
        return point;
    }

    private List<Point> decodePoints(Element parentElement) throws ParseException {
        LinkedList<Point> points = new LinkedList<Point>();
        List<Element> elements = this.getChildElements(parentElement, POINT_ELEMENT_NAME);
        for (Element element : elements) {
            Point point = this.decodePoint(element);
            points.add(point);
        }
        return points;
    }

    private void write(PrintWriter printWriter, String encoding, Flow flow) {
        String description;
        printWriter.printf("<?xml version='1.0' encoding='%s'?>\n", encoding);
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String flowName = flow.getName();
        if (flowName != null) {
            attributes.add(new Attribute("nome", flowName));
        }
        if ((description = flow.getDescription()) != null && !description.trim().isEmpty()) {
            attributes.add(new Attribute(FLOW_DESCRIPTION_NAME, description));
        }
        Attribute[] attributesArray = attributes.toArray(new Attribute[attributes.size()]);
        this.writeElementStart(printWriter, FLOW_ELEMENT_NAME, attributesArray);
        this.writeNodes(printWriter, flow.getNodes());
        this.writeLinks(printWriter, flow.getLinks());
        this.writeElementEnd(printWriter);
        printWriter.flush();
    }

    private void writeCDATA(PrintWriter printWriter, String value) {
        this.indent(printWriter);
        printWriter.print("<![CDATA[");
        printWriter.print(value);
        printWriter.println("]]>");
    }

    private void writeElementEnd(PrintWriter printWriter) {
        String elementName = this.elementNames.pop();
        this.indent(printWriter);
        printWriter.print("</");
        printWriter.print(elementName);
        printWriter.println(">");
    }

    private void writeElementStart(PrintWriter printWriter, String elementName, Attribute ... attributes) {
        this.indent(printWriter);
        printWriter.print("<");
        printWriter.print(elementName);
        for (Attribute attribute : attributes) {
            printWriter.print(" ");
            printWriter.print(attribute);
        }
        printWriter.println(">");
        this.elementNames.push(elementName);
    }

    private void writeLink(PrintWriter printWriter, FlowLink link) {
        LinkParameter inputLinkParameter = link.getInput();
        LinkParameter outputLinkParameter = link.getOutput();
        if (outputLinkParameter != null && inputLinkParameter != null) {
            Attribute idAttribute = new Attribute("id", link.getId());
            this.writeElementStart(printWriter, LINK_ELEMENT_NAME, idAttribute);
            this.writeLinkParameter(printWriter, OUTPUT_ELEMENT_NAME, outputLinkParameter);
            this.writeLinkParameter(printWriter, INPUT_ELEMENT_NAME, inputLinkParameter);
            this.writePoints(printWriter, link.getPoints());
            this.writeElementEnd(printWriter);
        }
    }

    private void writeLinkParameter(PrintWriter printWriter, String elementName, LinkParameter parameter) {
        Attribute nodeIdAttribute = new Attribute("no", parameter.getNodeId());
        Attribute nameAttribute = new Attribute("parametro", parameter.getName());
        Attribute labelAttribute = new Attribute("rotulo", parameter.getLabel());
        this.writeElementStart(printWriter, elementName, nodeIdAttribute, nameAttribute, labelAttribute);
        this.writeElementEnd(printWriter);
    }

    private void writeLinks(PrintWriter printWriter, Set<FlowLink> links) {
        for (FlowLink link : links) {
            this.writeLink(printWriter, link);
        }
    }

    private void writeNode(PrintWriter printWriter, FlowNode node) {
        AlgorithmInfo info;
        AlgorithmVersionInfo algorithmVersion;
        Attribute idAttribute = new Attribute("id", node.getId());
        this.writeElementStart(printWriter, "no", idAttribute);
        AlgorithmConfigurator algorithmConfigurator = node.getAlgorithmConfigurator();
        Attribute algorithmNameAttribute = new Attribute("nome", node.getAlgorithmName());
        String modifiedAlgorithmName = node.getLabel();
        Attribute modifiedNameAttribute = null;
        if (modifiedAlgorithmName != null) {
            modifiedNameAttribute = new Attribute("rotulo", modifiedAlgorithmName);
        }
        Attribute algorithmVersionAttribute = new Attribute(ALGORITHM_ATTRIBUTE_VERSION, node.getAlgorithmVersionId().toString());
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(algorithmNameAttribute);
        if (modifiedAlgorithmName != null) {
            attributes.add(modifiedNameAttribute);
        }
        attributes.add(algorithmVersionAttribute);
        if (algorithmConfigurator != null && (algorithmVersion = algorithmConfigurator.getAlgorithmVersion()) != null && (info = algorithmVersion.getInfo()) != null) {
            Attribute algorithmIdAttribute = new Attribute("id", info.getId());
            attributes.add(0, algorithmIdAttribute);
        }
        this.writeElementStart(printWriter, ALGORITHM_ELEMENT_NAME, attributes.toArray(new Attribute[0]));
        this.writeNodeParameters(printWriter, node.getParameters());
        this.writeNodeStandardOutput(printWriter, node);
        this.writeNodeExitCodeFile(printWriter, node);
        this.writeElementEnd(printWriter);
        this.writePoint(printWriter, node.getX(), node.getY());
        Attribute widthAttribute = new Attribute(SIZE_WIDTH_ATTRIBUTE, node.getWidth());
        Attribute heightAttribute = new Attribute(SIZE_HEIGHT_ATTRIBUTE, node.getHeight());
        this.writeElementStart(printWriter, SIZE_ELEMENT_NAME, widthAttribute, heightAttribute);
        this.writeElementEnd(printWriter);
        Attribute bypassedAttribute = new Attribute("valor", String.valueOf(node.isBypassed()));
        this.writeElementStart(printWriter, BYPASSED_ELEMENT_NAME, bypassedAttribute);
        this.writeElementEnd(printWriter);
        this.writeElementEnd(printWriter);
    }

    private void writeNodeParameter(PrintWriter printWriter, NodeParameter parameter) {
        Attribute nameAttribute = new Attribute("nome", parameter.getName());
        Attribute labelAttribute = new Attribute("rotulo", parameter.getLabel());
        Attribute typeAttribute = new Attribute("tipo", parameter.getType());
        this.writeElementStart(printWriter, "parametro", nameAttribute, labelAttribute, typeAttribute);
        String parameterValue = parameter.getValue();
        if (parameterValue != null) {
            this.writeElementStart(printWriter, "valor", new Attribute[0]);
            this.writeCDATA(printWriter, parameterValue);
            this.writeElementEnd(printWriter);
        }
        this.writeElementEnd(printWriter);
    }

    private void writeNodeParameters(PrintWriter printWriter, Set<NodeParameter> parameters) {
        for (NodeParameter parameter : parameters) {
            this.writeNodeParameter(printWriter, parameter);
        }
    }

    private void writeNodeStandardOutput(PrintWriter printWriter, FlowNode node) {
        AlgorithmConfigurator nodeConfigurator = node.getAlgorithmConfigurator();
        if (null == nodeConfigurator) {
            return;
        }
        FileURLValue stdout = nodeConfigurator.getStandardOutputFile();
        if (null == stdout) {
            return;
        }
        Attribute typeAttribute = new Attribute("tipo", stdout.getType());
        this.writeElementStart(printWriter, NODE_STDOUT_ELEMENT_NAME, typeAttribute);
        this.writeCDATA(printWriter, stdout.getPath());
        this.writeElementEnd(printWriter);
    }

    private void writeNodeExitCodeFile(PrintWriter printWriter, FlowNode node) {
        AlgorithmConfigurator nodeConfigurator = node.getAlgorithmConfigurator();
        if (null == nodeConfigurator) {
            return;
        }
        FileURLValue exitCodeFile = nodeConfigurator.getExitCodeLogFile();
        if (null == exitCodeFile || !nodeConfigurator.hasExitCode()) {
            return;
        }
        Attribute typeAttribute = new Attribute("tipo", exitCodeFile.getType());
        this.writeElementStart(printWriter, NODE_EXIT_CODE_ELEMENT_NAME, typeAttribute);
        this.writeCDATA(printWriter, exitCodeFile.getPath());
        this.writeElementEnd(printWriter);
    }

    private void writeNodes(PrintWriter printWriter, Set<FlowNode> nodes) {
        for (FlowNode node : nodes) {
            this.writeNode(printWriter, node);
        }
    }

    private void writePoint(PrintWriter printWriter, int x, int y) {
        Attribute xAttribute = new Attribute(POINT_X_ATTRIBUTE, x);
        Attribute yAttribute = new Attribute(POINT_Y_ATTRIBUTE, y);
        this.writeElementStart(printWriter, POINT_ELEMENT_NAME, xAttribute, yAttribute);
        this.writeElementEnd(printWriter);
    }

    private void writePoints(PrintWriter printWriter, List<Point> points) {
        for (Point point : points) {
            this.writePoint(printWriter, point.getX(), point.getY());
        }
    }

    private static final class Attribute {
        private String name;
        private String value;

        Attribute(String name, int value) {
            this(name, Integer.toString(value));
        }

        Attribute(String name, String value) {
            this.setName(name);
            this.setValue(value);
        }

        public String toString() {
            return this.name + "='" + this.value + "'";
        }

        private void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "this.name"));
            }
            this.name = name;
        }

        private void setValue(String value) {
            if (value == null) {
                throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "this.value"));
            }
            this.value = value;
        }
    }
}

