/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.exception.algorithms.FormulaEvaluationException;
import csbase.logic.algorithms.parameters.Expression;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public final class ValidationExpression
implements Serializable {
    private String errorMessage;
    private Expression expression;
    private SimpleAlgorithmConfigurator configurator;

    public ValidationExpression(SimpleAlgorithmConfigurator configurator, String expressionText, String errorMessage) throws FormulaCreationException, ParseException {
        this.setConfigurator(configurator);
        this.setErrorMessage(errorMessage);
        this.expression = new Expression(expressionText);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ValidationExpression exp = (ValidationExpression)obj;
        if (!this.getConfigurator().equals(exp.getConfigurator())) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public boolean evaluate() throws FormulaEvaluationException {
        return this.expression.evaluate(this.getConfigurator());
    }

    public SimpleAlgorithmConfigurator getConfigurator() {
        return this.configurator;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Set<SimpleParameter<?>> getParameters() {
        return this.expression.getParameters();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.expression.toString();
    }

    private void setConfigurator(SimpleAlgorithmConfigurator config) {
        if (config == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "configurator"));
        }
        this.configurator = config;
    }

    private void setErrorMessage(String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "expressionText"));
        }
        this.errorMessage = errorMessage;
    }
}

