/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public abstract class ExpressionFunction {
    private String name;
    private List<Class<?>> parameterTypes;

    public ExpressionFunction(String name, Class<?> ... parameterTypes) {
        this.setName(name);
        this.setParameterTypes(parameterTypes);
    }

    public final boolean acceptParameters(Object ... parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameters"));
        }
        if (parameters.length != this.parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            Object parameter = parameters[i];
            Class<?> expectedParameterType = this.parameterTypes.get(i);
            if (parameter == null) {
                if (!expectedParameterType.isPrimitive()) continue;
                return false;
            }
            Class<?> currentParameterType = parameter.getClass();
            if (currentParameterType.isPrimitive()) {
                currentParameterType = ExpressionFunction.getWrapperType(currentParameterType);
            }
            if (expectedParameterType.isAssignableFrom(currentParameterType)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ExpressionFunction)) {
            return false;
        }
        ExpressionFunction function = (ExpressionFunction)other;
        if (!function.name.equals(this.name)) {
            return false;
        }
        if (function.parameterTypes.size() != this.parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            if (this.parameterTypes.get(i).isAssignableFrom(function.parameterTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public final Object execute(SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException {
        if (configurator == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "configurator"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameters"));
        }
        if (!this.acceptParameters(parameters)) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidFunctionParameter"), this.toString(), Arrays.asList(parameters));
        }
        return this.doOperation(configurator, parameters);
    }

    public final String getName() {
        return this.name;
    }

    public final List<Class<?>> getParameterTypes() {
        return Collections.unmodifiableList(this.parameterTypes);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        String separator = "";
        buffer.append(this.name);
        buffer.append("(");
        for (Class<?> parameterType : this.parameterTypes) {
            buffer.append(separator);
            buffer.append(ExpressionFunction.getName(parameterType));
            separator = ", ";
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected abstract Object doOperation(SimpleAlgorithmConfigurator var1, Object ... var2) throws ExpressionFunctionExecutionException;

    private static String getName(Class<?> typeClass) {
        if (typeClass.isArray()) {
            return ExpressionFunction.getName(typeClass.getComponentType()) + "[]";
        }
        return typeClass.getName();
    }

    private static Class<?> getWrapperType(Class<?> primitiveType) {
        if (Boolean.TYPE.equals(primitiveType)) {
            return Boolean.class;
        }
        if (Byte.TYPE.equals(primitiveType)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(primitiveType)) {
            return Character.class;
        }
        if (Double.TYPE.equals(primitiveType)) {
            return Double.class;
        }
        if (Float.TYPE.equals(primitiveType)) {
            return Float.class;
        }
        if (Integer.TYPE.equals(primitiveType)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(primitiveType)) {
            return Long.class;
        }
        if (Short.TYPE.equals(primitiveType)) {
            return Short.class;
        }
        throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.NotPrimitiveType") + primitiveType);
    }

    private void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "name"));
        }
        this.name = name;
    }

    private void setParameterTypes(Class<?> ... parameterTypes) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterTypes"));
        }
        this.parameterTypes = new ArrayList(parameterTypes.length);
        for (Class<?> parameterType : parameterTypes) {
            if (parameterType == null) {
                throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.UnacceptedNullParameters") + Arrays.asList(parameterTypes));
            }
            if (parameterType.isPrimitive()) {
                parameterType = ExpressionFunction.getWrapperType(parameterType);
            }
            this.parameterTypes.add(parameterType);
        }
    }
}

