/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.URLListParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class InputURLListParameter
extends URLListParameter {
    public static final String TYPE_VALUE = "INPUT_URL";

    public InputURLListParameter(String name, String label, String description, List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String localization, String[] fileTypes, FileParameterMode mode, boolean mustSort, EnumSet<URLProtocol> allowedProtocols) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, localization, fileTypes, mode, mustSort, true, allowedProtocols);
    }

    @Override
    public String getType() {
        return TYPE_VALUE;
    }

    @Override
    public String getValueAsJSON() {
        ArrayList<String> files = new ArrayList<String>();
        if (this.getValue() != null) {
            for (FileURLValue file : (List)this.getValue()) {
                files.add(file.getPath());
            }
        }
        return this.objectToJSON(files);
    }

    @Override
    public void setJSONValue(Object value) {
        if (value == null) {
            this.setValue(null);
            return;
        }
        List list = (List)value;
        list.forEach(i -> this.addElement(FileURLValue.getURLFromString(this.getMode(), (String)i)));
    }
}

