/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.console.InfoTable;
import csbase.exception.CSBaseException;
import csbase.logic.BusInfo;
import csbase.logic.User;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.remote.ClientRemoteLocator;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import scs.core.ComponentId;

public class Diagnostics
extends AbstractConsoleApp {
    private Map<String, String> properties;

    public Diagnostics(String[] args) {
        super(args);
    }

    protected boolean runDiagnostics() throws RemoteException, UnknownHostException {
        boolean status = true;
        this.showBasicInfo();
        this.println("\n" + this.getDeploymentInfo(), new Object[0]);
        status &= this.runBasicNetworkDiagnostics();
        return status &= this.runOpenBusDiagnostics();
    }

    private boolean runOpenBusDiagnostics() throws RemoteException {
        Status status = ClientRemoteLocator.diagnosticService.getStatus("openbus");
        System.out.println("*** Status da conex\u00e3o com o barramento Openbus");
        for (ValidationStatus validationStatus : status.getValidationStatusList()) {
            this.println(validationStatus.message, new Object[0]);
        }
        boolean enabled = this.getBooleanProperty("OpenBusService.enabled");
        this.println();
        InfoTable section = new InfoTable("Conex\u00e3o com o barramento", false);
        if (!enabled) {
            section.add("status", "desabilitada");
            this.println(section.toString(), new Object[0]);
            return true;
        }
        boolean isActive = ClientRemoteLocator.openBusService.isActive();
        if (isActive) {
            section.add("status", "habilitada e ativa");
        } else {
            section.add("status", "habilitada e INATIVA", false);
        }
        BusInfo busInfo = ClientRemoteLocator.openBusService.getBusInfo();
        section.add("host", busInfo.getHost());
        section.add("porta", busInfo.getPort());
        this.println(section.toString(), new Object[0]);
        if (!isActive) {
            return false;
        }
        section = new InfoTable("Componentes registrados no barramento", true);
        Set components = ClientRemoteLocator.openBusService.getRegisteredComponents();
        if (components != null) {
            for (ComponentId componentId : components) {
                String version = String.format("v%d.%d.%d", componentId.major_version, componentId.minor_version, componentId.patch_version);
                section.add(componentId.name, version);
            }
            section.setOK(this.validateOpenBusComponents(components));
        } else {
            section.setOK(false);
        }
        this.println(section.toString(), new Object[0]);
        return section.isOK();
    }

    protected boolean validateOpenBusComponents(Set<ComponentId> components) {
        return true;
    }

    private boolean getBooleanProperty(String prop) {
        return Boolean.valueOf(this.properties.get(prop));
    }

    protected boolean runBasicNetworkDiagnostics() {
        return true;
    }

    @Override
    protected BasicParams createParams() {
        return new BasicParams();
    }

    @Override
    public final String getLogin() {
        return (String)User.getAdminId();
    }

    @Override
    protected void postLoginInit() throws RemoteException {
        this.properties = this.getRuntimeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws RemoteException, CSBaseException {
        Diagnostics diags = null;
        try {
            diags = new Diagnostics(args);
            if (diags.login()) {
                diags.runDiagnostics();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (diags != null) {
                diags.logout();
            }
        }
    }
}

