/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.client.ClientLocalFile;
import csbase.console.AbstractConsoleApp;
import csbase.console.AlgorithmsVersionParams;
import csbase.console.BasicParams;
import csbase.logic.ClientFile;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.remote.ClientRemoteLocator;
import java.io.File;
import java.io.InputStream;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;

public class ImportAlgoVersion
extends AbstractConsoleApp {
    ImportAlgoVersion(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new AlgorithmsVersionParams();
    }

    @Override
    protected void postLoginInit() {
    }

    /*
     * Loose catch block
     */
    private static boolean transfer(ClientFile file, RemoteFileChannelInfo info) throws Exception {
        SyncRemoteFileChannel channel = new SyncRemoteFileChannel(info.getIdentifier(), info.isWritable(), info.getHost(), info.getPort(), info.getKey());
        channel.open(!info.isWritable());
        try {
            try (InputStream inputStream = file.getInputStream();){
                long totalBytes = channel.syncTransferFrom(inputStream, 0L, file.size());
                boolean bl = totalBytes == file.size();
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            channel.close();
        }
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        AlgorithmsVersionParams params = (AlgorithmsVersionParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    private File getLocalSrcFile(String localSrcPath) {
        System.out.println(localSrcPath);
        File localFile = localSrcPath.charAt(0) != '/' ? new File(this.getCurrentDir(), localSrcPath) : new File(localSrcPath);
        if (!localFile.exists()) {
            this.printError(localSrcPath + " n\u00e3o existe", new Object[0]);
            return null;
        }
        if (localFile.isDirectory()) {
            this.printError(localSrcPath + " \u00e9 um diret\u00f3rio", new Object[0]);
            return null;
        }
        return localFile;
    }

    private void execute() throws Exception {
        AlgorithmsVersionParams params = (AlgorithmsVersionParams)this.getParams();
        this.startAlgorithmImport(params.algorithmId, params.versionZipPath);
    }

    private void startAlgorithmImport(String algorithmId, String zipPath) throws Exception {
        AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo((Object)algorithmId);
        if (info == null) {
            System.err.println("Id de algoritmo inv\u00e1lido.");
            return;
        }
        String filename = FileUtils.getFileName((String)zipPath);
        RemoteFileChannelInfo channelInfo = ClientRemoteLocator.algorithmService.prepareUploadVersionPack((Object)algorithmId, filename);
        File localFile = this.getLocalSrcFile(zipPath);
        if (localFile == null) {
            System.err.println("Path inexistente para vers\u00e3o de algoritmo.");
            return;
        }
        ClientLocalFile clientFile = new ClientLocalFile(localFile);
        if (!ImportAlgoVersion.transfer((ClientFile)clientFile, channelInfo)) {
            this.logout();
        }
    }

    public static void main(String[] args) throws Exception {
        ImportAlgoVersion importVersionClient = new ImportAlgoVersion(args);
        if (importVersionClient.login()) {
            System.out.println("Processo de importa\u00e7\u00e3o de uma Vers\u00e3o de Algoritmo...");
            importVersionClient.execute();
            importVersionClient.logout();
        }
    }
}

