package csbase.console;

import csbase.exception.PermissionException;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * Cliente sem interface grfica, para realizar remoo de Algoritmo. Esse
 * cliente deve ser executado diretamente da linha de comando.
 *
 * @author Tecgraf
 */
class RemoveAlgorithm extends AbstractConsoleApp {

  /**
   * Construtor do cliente para remover um algoritmo. Obtm a senha
   * interativamente.
   *
   * @param args parmetros fornecidos na linha de comando
   */
  RemoveAlgorithm(String[] args) {
    super(args);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected RemoveAlgorithmParams createParams() {
    return new RemoveAlgorithmParams();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void postLoginInit() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean preLogout() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    RemoveAlgorithmParams params = (RemoveAlgorithmParams) getParams();
    String login = (String) (params.userLogin == null ? User.getAdminId()
      : params.userLogin);
    return login;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExitCode execute() throws Exception {
    RemoveAlgorithmParams params = (RemoveAlgorithmParams) getParams();
    return startRemoveAlgorithm(params.algorithmId);
  }

  /**
   * Remove algoritmo.
   *
   * @param algorithmId Id do algoritmo.
   * @return Cdigo de sada.
   * @throws Exception Erro na obteno de verses do algoritmo.
   */
  private static ExitCode startRemoveAlgorithm(String algorithmId)
    throws Exception {
    /*
     * TODO: Cast pra Object necessrio pois alm do getInfo(Object) desejado,
     * existe um mtodo getInfo(String) que espera no o id mas o nome do
     * algoritmo. Talvez fosse o caso destes mtodos terem nomes diferentes.
     */
    AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo(
      (Object) algorithmId);
    if (info == null) {
      System.err.println("Id de algoritmo no encontrado.");
      // Exit code de id de algoritmo invlido.
      return ExitCode.FAILURE;
    }

    try {
      if (!ClientRemoteLocator.algorithmService.removeAlgorithm(algorithmId)) {
        System.out.println("Falha na remoo do algoritmo.");
        // Exit code de id de falha na remoo do algoritmo.
        return ExitCode.FAILURE;
      }
    }
    catch (PermissionException e) {
      System.out.println("Usurio no tem permisso para remover algoritmo "
        + algorithmId);
      // Exit code de falha de permisso na remoo de algoritmo.
      return ExitCode.FAILURE;
    }
    System.out.println("Algoritmo " + algorithmId + " removido com sucesso.");
    // Exit code de sucesso.
    return ExitCode.SUCCESS;
  }

}
