package csbase.console;

import java.text.MessageFormat;

import javax.swing.JFrame;

import csbase.client.Client;
import csbase.client.ClientUI;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.login.InitialContext;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import tecgraf.javautils.core.lng.LNG;

/**
 * Cliente do CSBase que executa a aplicao de diagnstico do servidor.
 *
 * @author Tecgraf PUC-Rio
 */
class VisualAdminUI implements ClientUI {

  /**
   * Desktop do cliente, no visivel.  obrigatrio que todo cliente CSBase
   * tenha um desktop instanciado.
   */
  DesktopFrame mainFrame;

  /**
   *
   * {@inheritDoc}
   *
   * @throws ClientException se houver um erro na criao do desktop
   */
  @Override
  public void preInitialization(InitialContext initialContext)
    throws ClientException {
    mainFrame = new DesktopFrame();
  }

  /**
   *
   * {@inheritDoc}
   */
  @Override
  public void showUI() {
    try {
      if (!User.getLoggedUser().isAdmin()) {
        final String err =
          MessageFormat.format(LNG.get("VisualAdminUI.message.user.not.admin"),
            User.getLoggedUser().getName());
        StandardErrorDialogs.showErrorDialog(this.getView(), err);
        Client.getInstance().shutdown();
      }
      else {
        ApplicationManager.getInstance()
          .addListener(new ApplicationManagerListener() {

            @Override
            public void applicationEnded(String id) {
              if (id.equals("serverdiagnostic")) {
                exitClient();
              }
            }

            @Override
            public void applicationStarted(String id) {
            }
          });
        ApplicationManager.getInstance().runApplication("serverdiagnostic");
      }
    }
    catch (ApplicationException e) {
      Client.getInstance().shutdown();
    }
  }

  /**
   *
   * {@inheritDoc}
   */
  @Override
  public void postInitialization() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public JFrame getView() {
    return mainFrame.getDesktopFrame();
  }

  /**
   * Finaliza o cliente.
   */
  public void exitClient() {
    ApplicationManager.getInstance().finishAllApplications();
    /*
     * Remove os ouvintes de mensagens do cliente, fazendo com que o consumo de
     * mensagens do servidor seja interrompido.
     */
    MessageProxy.clearListeners();
    Client.getInstance().shutdown();
  }

}
