/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.console.RemoveAlgoVersionParams;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.ClientRemoteLocator;
import java.util.Arrays;
import java.util.List;

public class RemoveAlgoVersion
extends AbstractConsoleApp {
    RemoveAlgoVersion(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new RemoveAlgoVersionParams();
    }

    @Override
    protected void postLoginInit() {
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        RemoveAlgoVersionParams params = (RemoveAlgoVersionParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    private void execute() throws Exception {
        RemoveAlgoVersionParams params = (RemoveAlgoVersionParams)this.getParams();
        RemoveAlgoVersion.startAlgorithmRemoval(params.algorithmId, params.versionId);
    }

    private static void startAlgorithmRemoval(String algorithmId, String versionId) throws Exception {
        AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo((Object)algorithmId);
        if (info == null) {
            System.err.println("Id de algoritmo inv\u00e1lido.");
            return;
        }
        List<Object> list = Arrays.asList(info.getVersionIds());
        for (Object obj : list) {
            if (!obj.toString().equalsIgnoreCase(versionId)) continue;
            ClientRemoteLocator.algorithmService.removeVersion((Object)algorithmId, (Object)AlgorithmVersionId.create((String)versionId));
            System.out.println("Vers\u00e3o " + versionId + " removida.");
            return;
        }
        System.err.println("Vers\u00e3o n\u00e3o encontrada.");
    }

    public static void main(String[] args) throws Exception {
        RemoveAlgoVersion removeVersionClient = new RemoveAlgoVersion(args);
        if (removeVersionClient.login()) {
            System.out.println("Processo de remo\u00e7\u00e3o de Vers\u00e3o de Algoritmo...");
            removeVersionClient.execute();
            removeVersionClient.logout();
        }
    }
}

