# $Id$
#
# Este arquivo define variveis de ambiente correspondentes s libs
# disponibilizadas pelo CSBase para os outros projetos, para facilitar
# e centralizar as referncias a estas. Upgrades de verses de
# bibliotecas sero atualizados aqui, e todos os scripts que fizerem
# uso deste arquivo automaticamente utilizaro as novas verses.
# 
# O nico pr-requisito  que a varivel de ambiente CSBASE_DIR seja
# definida para apontar para o diretrio-raiz do CSBase. Como este local
# varia de projeto para projeto, esta definio deve ser feita nos
# scripts _antes_ da incluso deste script.
#
# O uso tpico deste arquivo :
# ...
# CSBASE_DIR=[path para o diretrio pai de csbase]
# . $CSBASE_DIR/conf/csbase.sh
# ...

# Funo para trocar o separador ":" por espaos. Funciona apenas para
# as variveis UNIX.
#
# Exemplos de uso:
# FILES=`withSpaces $JAR_JACORB`
# cp `withSpaces $JAR_JACORB` /tmp
withSpaces () {
    print "$@" | tr : \ 
}

# a varivel CSBASE_LIBS deve ter sido previamente definida
export CSBASE_LIBS=$CSBASE_DIR/csbase/libs

# converte um classpath UNIX para Windows
toWin () {
    print $1 | tr ':' ';' | sed "s,/,\\\\\\\\,g"
}

# Busca dentro de um diretrio todos os JARs que devem ser includos no 
# classpath (para cada subdiretrio), gerando dinamicamente uma varivel 
# com o nome:
# JAR_<NOME_DIR>=<DIRECTORY>/<nome_dir>/*, onde DIRECTORY  $1.
# As variveis JAR_xxx_WIN so geradas dinamicamente a partir das
# variveis JAR_xxx correspondentes
processJarDirectory() {
 directory="$1"
 for subdir in ${directory}/* ; do
     if test -d $subdir ; then
       subdirname="$(basename $subdir)"
       DIR="$(print $subdirname | tr '[a-z]-' '[A-Z]_')"
       files="$(find $directory/$subdirname -type d -name .svn -prune -o -type f -name '*jar' -print)"
       classpathJars="$(print $files | tr ' ' ':')"
       eval "export JAR_${DIR}=\"$classpathJars\""
       set -f
       eval "export JAR_${DIR}_WIN=\"$(toWin $classpathJars)\""
       set +f
     fi
 done
}


processJarDirectory ${CSBASE_LIBS} 
