/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.authorization.access;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.authorization.IResourceAuthorizerConsumer;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class FindAllResourcesAuthorizedToUserCommand
extends AbstractCommand<List<Resource>> {
    private IResourceAuthorizerConsumer resourceAuthorizerConsumer;
    private String userLoginArg;
    private boolean considerContextArg = false;
    private ContextValueSet contextValueSetArg;
    private boolean ignoreManagerPrivilege = false;

    public IResourceAuthorizerConsumer getResourceAuthorizerConsumer() {
        return this.resourceAuthorizerConsumer;
    }

    public void setResourceAuthorizerConsumer(IResourceAuthorizerConsumer resourceAuthorizerConsumer) {
        this.resourceAuthorizerConsumer = resourceAuthorizerConsumer;
    }

    public String getUserLoginArg() {
        return this.userLoginArg;
    }

    public void setUserLoginArg(String userLoginArg) {
        this.userLoginArg = userLoginArg;
    }

    public boolean isConsiderContextArg() {
        return this.considerContextArg;
    }

    public void setConsiderContextArg(boolean considerContextArg) {
        this.considerContextArg = considerContextArg;
    }

    public ContextValueSet getContextValueSetArg() {
        return this.contextValueSetArg;
    }

    public void setContextValueSetArg(ContextValueSet contextValueSet) {
        this.contextValueSetArg = contextValueSet;
    }

    public boolean isIgnoreManagerPrivilege() {
        return this.ignoreManagerPrivilege;
    }

    public void setIgnoreManagerPrivilege(boolean ignoreManagerPrivilege) {
        this.ignoreManagerPrivilege = ignoreManagerPrivilege;
    }

    @Override
    protected void executeConsume() {
        MessageHeader messageHeader = super.getMessageHeader();
        String userLogin = this.getUserLoginArg();
        if (Validator.isNullOrEmpty((String)userLogin)) {
            userLogin = super.getUserContextIdentifier().getCurrentUserContext().getLoggedUser().getLogin();
        }
        super.setReturnMessage(this.getResourceAuthorizerConsumer().findAll(messageHeader, userLogin, this.getContextValueSetArg(), this.isConsiderContextArg()));
    }
}

