/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.command.authorization.access;

import br.com.petrobras.security.command.AbstractCommand;
import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.authorization.IResourceAuthorizerConsumer;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.authorization.access.map.ResourceAuthorizationMapItem;
import br.com.petrobras.security.utility.Validator;
import java.util.Map;

public class GetResourceAuthorizationsMapOfUserCommand
extends AbstractCommand<Map<String, ResourceAuthorizationMapItem>> {
    private IResourceAuthorizerConsumer resourceAuthorizerConsumer;
    private String userLoginArg;
    private boolean considerContextArg = false;
    private ContextValueSet contextValueSetArg;

    public IResourceAuthorizerConsumer getResourceAuthorizerConsumer() {
        return this.resourceAuthorizerConsumer;
    }

    public void setResourceAuthorizerConsumer(IResourceAuthorizerConsumer resourceAuthorizerConsumer) {
        this.resourceAuthorizerConsumer = resourceAuthorizerConsumer;
    }

    public String getUserLoginArg() {
        return this.userLoginArg;
    }

    public void setUserLoginArg(String userLoginArg) {
        this.userLoginArg = userLoginArg;
    }

    public boolean isConsiderContextArg() {
        return this.considerContextArg;
    }

    public void setConsiderContextArg(boolean considerContextArg) {
        this.considerContextArg = considerContextArg;
    }

    public ContextValueSet getContextValueSetArg() {
        return this.contextValueSetArg;
    }

    public void setContextValueSetArg(ContextValueSet contextValueSet) {
        this.contextValueSetArg = contextValueSet;
    }

    @Override
    protected void executeConsume() {
        MessageHeader messageHeader = super.getMessageHeader();
        String userLogin = this.getUserLoginArg();
        if (Validator.isNullOrEmpty((String)userLogin)) {
            userLogin = super.getUserContextIdentifier().getCurrentUserContext().getLoggedUser().getLogin();
        }
        super.setReturnMessage(this.getResourceAuthorizerConsumer().getMap(messageHeader, userLogin, this.getContextValueSetArg(), this.isConsiderContextArg()));
    }
}

