/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IApplicationEnvironmentAuthorizer;
import br.com.petrobras.security.command.authorization.basic.FindAllUserApplicationEnvironmentsCommand;
import br.com.petrobras.security.command.authorization.basic.VerifyIfUserHasAnyAuthorizationCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class ApplicationEnvironmentAuthorizerCoreImpl
implements IApplicationEnvironmentAuthorizer {
    private static final long serialVersionUID = 1328042336826713469L;

    public boolean hasAnyAuthorization() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        VerifyIfUserHasAnyAuthorizationCommand cmd = ICommandIdentifier.getInstance().getVerifyIfUserHasAnyAuthorizationCommand();
        return (Boolean)cmd.execute();
    }

    public boolean hasAnyAuthorization(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyIfUserHasAnyAuthorizationCommand cmd = ICommandIdentifier.getInstance().getVerifyIfUserHasAnyAuthorizationCommand();
        cmd.setUserLoginArg(userLogin);
        return (Boolean)cmd.execute();
    }

    public boolean hasAnyAuthorization(User user) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.hasAnyAuthorization(user.getLogin());
    }

    public List<ApplicationEnvironment> findAll(Environment environment) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)environment);
        Validator.throwInvalidArgumentExceptionIfNull((Object)environment.getRegional());
        return this.findAll(environment.getRegional().getId(), environment.getId());
    }

    public List<ApplicationEnvironment> findAll(String regionalId, String environmentId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllUserApplicationEnvironmentsCommand cmd = ICommandIdentifier.getInstance().getFindAllUserApplicationEnvironmentsCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        return (List)cmd.execute();
    }

    public List<ApplicationEnvironment> findAll(User user, Environment environment) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        Validator.throwInvalidArgumentExceptionIfNull((Object)environment);
        Validator.throwInvalidArgumentExceptionIfNull((Object)environment.getRegional());
        return this.findAll(user.getLogin(), environment.getRegional().getId(), environment.getId());
    }

    public List<ApplicationEnvironment> findAll(String userLogin, String regionalId, String environmentId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllUserApplicationEnvironmentsCommand cmd = ICommandIdentifier.getInstance().getFindAllUserApplicationEnvironmentsCommand();
        cmd.setUserLoginArg(userLogin);
        cmd.setRegionalIdArg(regionalId);
        cmd.setEnvironmentIdArg(environmentId);
        return (List)cmd.execute();
    }
}

