/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.ISecurityContext;
import br.com.petrobras.security.authorization.IInformationAuthorizer;
import br.com.petrobras.security.command.authorization.information.VerifyIfInformationIsSharedToApplicationCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.Regional;

public class InformationAuthorizerCoreImpl
implements IInformationAuthorizer {
    private static final long serialVersionUID = 8426731603291767508L;

    public boolean isSharedToApplication(String applicationCatalogIdOwnerOfInformation, String informationId) throws IllegalArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyIfInformationIsSharedToApplicationCommand cmd = ICommandIdentifier.getInstance().getVerifyIfInformationIsSharedToApplicationCommand();
        Environment environment = ISecurityContext.getContext().getCurrentConnectedApplicationEnvironment().getEnvironment();
        Regional regional = environment.getRegional();
        cmd.setRegionalIdArg(regional.getId());
        cmd.setApplicationCatalogIdOwnerOfInformationArg(applicationCatalogIdOwnerOfInformation);
        cmd.setInformationIdArg(informationId);
        return (Boolean)cmd.execute();
    }

    public boolean isSharedToApplication(String regionalId, String applicationCatalogIdOwnerOfInformation, String informationId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyIfInformationIsSharedToApplicationCommand cmd = ICommandIdentifier.getInstance().getVerifyIfInformationIsSharedToApplicationCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdOwnerOfInformationArg(applicationCatalogIdOwnerOfInformation);
        cmd.setInformationIdArg(informationId);
        return (Boolean)cmd.execute();
    }
}

