/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IInformationValueAuthorizer;
import br.com.petrobras.security.command.authorization.information.FindAllInformationValueAuthorizedToUserCommand;
import br.com.petrobras.security.command.authorization.information.VerifyInformationValueAuthorizationToUserCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.InformationValue;
import java.util.List;

public class InformationValueAuthorizerCoreImpl
implements IInformationValueAuthorizer {
    public boolean isAuthorized(String informationId, String informationValueId) {
        return this.isAuthorizedInContext(null, informationId, informationValueId, null, null, null);
    }

    public boolean isAuthorized(ApplicationEnvironment ownerApplicationEnvironment, String informationId, String informationValueId) {
        return this.isAuthorizedInContext(ownerApplicationEnvironment, informationId, informationValueId, null, null, null);
    }

    public boolean isAuthorized(String informationId, String informationValueId, ContextValueSet contextValuesSet) {
        return this.isAuthorizedInContext(null, informationId, informationValueId, null, null, contextValuesSet);
    }

    public boolean isAuthorized(ApplicationEnvironment ownerApplicationEnvironment, String informationId, String informationValueId, ContextValueSet contextValuesSet) {
        return this.isAuthorizedInContext(ownerApplicationEnvironment, informationId, informationValueId, null, null, contextValuesSet);
    }

    public boolean isAuthorized(String informationId, String informationValueId, String userLogin) {
        return this.isAuthorizedInContext(null, informationId, informationValueId, userLogin, null, null);
    }

    public boolean isAuthorized(String informationId, String informationValueId, String userLogin, String areaId) {
        return this.isAuthorizedInContext(null, informationId, informationValueId, userLogin, areaId, null);
    }

    public boolean isAuthorized(String informationId, String informationValueId, String userLogin, ContextValueSet contextValuesSet) {
        return this.isAuthorizedInContext(null, informationId, informationValueId, null, null, contextValuesSet);
    }

    public boolean isAuthorized(String informationId, String informationValueId, String userLogin, String areaId, ContextValueSet contextValuesSet) {
        return this.isAuthorizedInContext(null, informationId, informationValueId, userLogin, areaId, contextValuesSet);
    }

    public boolean isAuthorized(ApplicationEnvironment ownerApplicationEnvironment, String informationId, String informationValueId, String userLogin) {
        return this.isAuthorizedInContext(ownerApplicationEnvironment, informationId, informationValueId, userLogin, null, null);
    }

    public boolean isAuthorized(ApplicationEnvironment ownerApplicationEnvironment, String informationId, String informationValueId, String userLogin, ContextValueSet contextValuesSet) {
        return this.isAuthorizedInContext(ownerApplicationEnvironment, informationId, informationValueId, userLogin, null, contextValuesSet);
    }

    public boolean isAuthorized(ApplicationEnvironment ownerApplicationEnvironment, String informationId, String informationValueId, String userLogin, String areaId) {
        return this.isAuthorizedInContext(ownerApplicationEnvironment, informationId, informationValueId, userLogin, areaId, null);
    }

    public boolean isAuthorized(ApplicationEnvironment ownerApplicationEnvironment, String informationId, String informationValueId, String userLogin, String areaId, ContextValueSet contextValuesSet) {
        return this.isAuthorizedInContext(ownerApplicationEnvironment, informationId, informationValueId, userLogin, areaId, contextValuesSet);
    }

    public List<InformationValue> findAll(String informationId, String userLogin) {
        return this.findAllAuthorizedInContext(informationId, userLogin, null, null);
    }

    public List<InformationValue> findAll(String informationId, String userLogin, ContextValueSet contextValuesSet) {
        return this.findAllAuthorizedInContext(informationId, userLogin, null, contextValuesSet);
    }

    public List<InformationValue> findAll(String informationId, String userLogin, String areaId) {
        return this.findAllAuthorizedInContext(informationId, userLogin, areaId, null);
    }

    public List<InformationValue> findAll(String informationId, String userLogin, String areaId, ContextValueSet contextValuesSet) {
        return this.findAllAuthorizedInContext(informationId, userLogin, areaId, contextValuesSet);
    }

    public List<InformationValue> findAll(String informationId) {
        return this.findAllAuthorizedInContext(informationId, null, null, null);
    }

    public List<InformationValue> findAll(String informationId, ContextValueSet contextValuesSet) {
        return this.findAllAuthorizedInContext(informationId, null, null, contextValuesSet);
    }

    private boolean isApplicationEnvironmentFilled(ApplicationEnvironment applicationEnvironment) {
        if (applicationEnvironment == null) {
            return false;
        }
        if (applicationEnvironment.getEnvironment() == null) {
            return false;
        }
        if (applicationEnvironment.getEnvironment().getRegional() == null) {
            return false;
        }
        return applicationEnvironment.getApplication() != null;
    }

    private boolean isAuthorizedInContext(ApplicationEnvironment appEnv, String informationId, String informationValueId, String userLogin, String areaId, ContextValueSet contextValuesSet) {
        VerifyInformationValueAuthorizationToUserCommand cmd = ICommandIdentifier.getInstance().getVerifyInformationValueAuthorizationToUserCommand();
        String regionalId = null;
        String applicationCatalogId = null;
        if (this.isApplicationEnvironmentFilled(appEnv)) {
            regionalId = appEnv.getEnvironment().getRegional().getId();
            applicationCatalogId = appEnv.getApplication().getCatalogId();
        }
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.setUserLoginArg(userLogin);
        cmd.setTargetAreaIdArg(areaId);
        if (contextValuesSet != null) {
            cmd.setConsiderContextArg(true);
        }
        cmd.setContextValuesSetArg(contextValuesSet);
        return (Boolean)cmd.execute();
    }

    private List<InformationValue> findAllAuthorizedInContext(String informationId, String userLogin, String areaId, ContextValueSet contextValuesSet) {
        FindAllInformationValueAuthorizedToUserCommand cmd = ICommandIdentifier.getInstance().getFindAllInformationValueAuthorizedToUserCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setUserLoginArg(userLogin);
        cmd.setTargetAreaIdArg(areaId);
        if (contextValuesSet != null) {
            cmd.setConsiderContextArg(true);
        }
        cmd.setContextValuesSetArg(contextValuesSet);
        return (List)cmd.execute();
    }
}

