/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.FindAllAreaMngmntAuthorizationsCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.FindAllAreaMngmntAuthorizationsOfAreaCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.FindAreaMngmntAuthOfUserCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.GrantAreaMngmntAuthOwnerOptToUserCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.GrantAreaMngmntAuthToUserCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.GrantOwnerOptionToAreaMngmntAuthCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.RevokeAreaMngmntAuthFromUserCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.RevokeOwnerOptionFromAreaMngmntAuthCommand;
import br.com.petrobras.security.command.management.authorization.areamanagementauthorizationmanager.UpdateAreaMngmntAuthOfUserCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IAreaManagementAuthorizationManager;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.authorization.basic.AreaManagementAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class AreaManagementAuthorizationManagerCoreImpl
implements IAreaManagementAuthorizationManager {
    public void grant(Area area, User user) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(area.getId(), user.getLogin());
    }

    public void grant(String areaId, String userLogin) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void grant(Area area, User user, Expiration expiration) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(area.getId(), user.getLogin(), expiration);
    }

    public void grant(String areaId, String userLogin, Expiration expiration) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void grant(Area area, User user, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(area.getId(), user.getLogin(), enabled, dataAuthorization, hierarchical);
    }

    public void grant(String areaId, String userLogin, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setDataAuthorizationArg(dataAuthorization.booleanValue());
        cmd.setHierarchicalArg(hierarchical.booleanValue());
        cmd.execute();
    }

    public void grant(Area area, User user, Expiration expiration, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grant(area.getId(), user.getLogin(), expiration, enabled, dataAuthorization, hierarchical);
    }

    public void grant(String areaId, String userLogin, Expiration expiration, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setDataAuthorizationArg(dataAuthorization.booleanValue());
        cmd.setHierarchicalArg(hierarchical.booleanValue());
        cmd.execute();
    }

    public void update(Area area, User user, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.update(area.getId(), user.getLogin(), enabled, dataAuthorization, hierarchical);
    }

    public void update(String areaId, String userLogin, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        UpdateAreaMngmntAuthOfUserCommand cmd = ICommandIdentifier.getInstance().getUpdateAreaMngmntAuthOfUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setDataAuthorizationArg(dataAuthorization.booleanValue());
        cmd.setHierarchicalArg(hierarchical.booleanValue());
        cmd.execute();
    }

    public void update(Area area, User user, Expiration expiration, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.update(area.getId(), user.getLogin(), expiration, enabled, dataAuthorization, hierarchical);
    }

    public void update(String areaId, String userLogin, Expiration expiration, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        UpdateAreaMngmntAuthOfUserCommand cmd = ICommandIdentifier.getInstance().getUpdateAreaMngmntAuthOfUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setDataAuthorizationArg(dataAuthorization.booleanValue());
        cmd.setHierarchicalArg(hierarchical.booleanValue());
        cmd.execute();
    }

    public void revoke(Area area, User user) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.revoke(area.getId(), user.getLogin());
    }

    public void revoke(String areaId, String userLogin) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        RevokeAreaMngmntAuthFromUserCommand cmd = ICommandIdentifier.getInstance().getRevokeAreaMngmntAuthFromUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void grantWithOwnerOption(Area area, User user) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(area.getId(), user.getLogin());
    }

    public void grantWithOwnerOption(String areaId, String userLogin) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthOwnerOptToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void grantWithOwnerOption(Area area, User user, Expiration expiration) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(area.getId(), user.getLogin(), expiration);
    }

    public void grantWithOwnerOption(String areaId, String userLogin, Expiration expiration) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthOwnerOptToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.execute();
    }

    public void grantWithOwnerOption(Area area, User user, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(area.getId(), user.getLogin(), enabled, dataAuthorization, hierarchical);
    }

    public void grantWithOwnerOption(String areaId, String userLogin, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthOwnerOptToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setDataAuthorizationArg(dataAuthorization.booleanValue());
        cmd.setHierarchicalArg(hierarchical.booleanValue());
        cmd.execute();
    }

    public void grantWithOwnerOption(Area area, User user, Expiration expiration, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantWithOwnerOption(area.getId(), user.getLogin(), expiration, enabled, dataAuthorization, hierarchical);
    }

    public void grantWithOwnerOption(String areaId, String userLogin, Expiration expiration, Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantAreaMngmntAuthOwnerOptToUserCommand cmd = ICommandIdentifier.getInstance().getGrantAreaMngmntAuthOwnerOptToUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.setExpirationArg(expiration);
        cmd.setAuthorizationEnabledArg(enabled.booleanValue());
        cmd.setDataAuthorizationArg(dataAuthorization.booleanValue());
        cmd.setHierarchicalArg(hierarchical.booleanValue());
        cmd.execute();
    }

    public void grantOwnerOption(Area area, User user) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.grantOwnerOption(area.getId(), user.getLogin());
    }

    public void grantOwnerOption(String areaId, String userLogin) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        GrantOwnerOptionToAreaMngmntAuthCommand cmd = ICommandIdentifier.getInstance().getGrantOwnerOptionToAreaMngmntAuthCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public void revokeOwnerOption(Area area, User user) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        this.revokeOwnerOption(area.getId(), user.getLogin());
    }

    public void revokeOwnerOption(String areaId, String userLogin) throws InvalidArgumentException, ObjectNotFoundException, InvalidOperationException, PermissionDeniedException, SecurityException {
        RevokeOwnerOptionFromAreaMngmntAuthCommand cmd = ICommandIdentifier.getInstance().getRevokeOwnerOptionFromAreaMngmntAuthCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        cmd.execute();
    }

    public AreaManagementAuthorization find(Area area, User user) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        Validator.throwInvalidArgumentExceptionIfNull((Object)user);
        return this.find(area.getId(), user.getLogin());
    }

    public AreaManagementAuthorization find(String areaId, String userLogin) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAreaMngmntAuthOfUserCommand cmd = ICommandIdentifier.getInstance().getFindAreaMngmntAuthOfUserCommand();
        cmd.setAreaIdArg(areaId);
        cmd.setUserLoginArg(userLogin);
        return (AreaManagementAuthorization)cmd.execute();
    }

    public List<AreaManagementAuthorization> findAll() throws PermissionDeniedException, SecurityException {
        FindAllAreaMngmntAuthorizationsCommand cmd = ICommandIdentifier.getInstance().getFindAllAreaMngmntAuthorizationsCommand();
        return (List)cmd.execute();
    }

    public List<AreaManagementAuthorization> findAllInArea(Area area) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)area);
        return this.findAllInArea(area.getId());
    }

    public List<AreaManagementAuthorization> findAllInArea(String areaId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllAreaMngmntAuthorizationsOfAreaCommand cmd = ICommandIdentifier.getInstance().getFindAllAreaMngmntAuthorizationsOfAreaCommand();
        cmd.setAreaIdArg(areaId);
        return (List)cmd.execute();
    }
}

