/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.enterprisegroupinformationvalue.FindAllEnterpriseGroupInfoValueAuthorizationWithEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegroupinformationvalue.FindAllEnterpriseGroupInfoValueAuthorizationWithInfoValueCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegroupinformationvalue.GrantInformationValueAuthorizationToEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegroupinformationvalue.GrantSharedInformationValueAuthorizationToEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegroupinformationvalue.RevokeInformationValueAuthorizationFromEnterpriseGroupCommand;
import br.com.petrobras.security.command.management.authorization.enterprisegroupinformationvalue.RevokeSharedInformationValueAuthorizationFromEnterpriseGroupCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IEnterpriseGroupInformationValueAuthorizationManager;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.EnterpriseGroup;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.model.authorization.information.EnterpriseGroupInformationValueAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class EnterpriseGroupInformationValueAuthorizationManagerCoreImpl
implements IEnterpriseGroupInformationValueAuthorizationManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public List<EnterpriseGroupInformationValueAuthorization> findAllWithEnterpriseGroup(EnterpriseGroup enterpriseGroup) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        return this.findAllWithEnterpriseGroup(enterpriseGroup.getId());
    }

    public List<EnterpriseGroupInformationValueAuthorization> findAllWithEnterpriseGroup(String enterpriseGroupId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroupId);
        FindAllEnterpriseGroupInfoValueAuthorizationWithEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupInfoValueAuthorizationWithEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        return (List)cmd.execute();
    }

    public List<EnterpriseGroupInformationValueAuthorization> findAllWithInformationValue(InformationValue informationValue) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            return this.findAllWithInformationValue(informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        }
        return this.findAllWithInformationValue(informationValue.getInformation().getId(), informationValue.getId());
    }

    public List<EnterpriseGroupInformationValueAuthorization> findAllWithInformationValue(String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllEnterpriseGroupInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupInfoValueAuthorizationWithInfoValueCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }

    public void grant(EnterpriseGroup enterpriseGroup, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.grant(enterpriseGroup.getId(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.grant(enterpriseGroup.getId(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void grant(String enterpriseGroupId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantInformationValueAuthorizationToEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getGrantInformationValueAuthorizationToEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void grant(String enterpriseGroupId, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantSharedInformationValueAuthorizationToEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getGrantSharedInformationValueAuthorizationToEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(EnterpriseGroup enterpriseGroup, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)enterpriseGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.revoke(enterpriseGroup.getId(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.revoke(enterpriseGroup.getId(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void revoke(String enterpriseGroupId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeInformationValueAuthorizationFromEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getRevokeInformationValueAuthorizationFromEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(String enterpriseGroupId, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeSharedInformationValueAuthorizationFromEnterpriseGroupCommand cmd = ICommandIdentifier.getInstance().getRevokeSharedInformationValueAuthorizationFromEnterpriseGroupCommand();
        cmd.setEnterpriseGroupIdArg(enterpriseGroupId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public List<EnterpriseGroupInformationValueAuthorization> findAllWithInformationValue(String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllEnterpriseGroupInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllEnterpriseGroupInfoValueAuthorizationWithInfoValueCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }
}

