/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.roleusecase.FindAllRoleUseCaseAuthorizationsByRoleCommand;
import br.com.petrobras.security.command.management.authorization.roleusecase.GrantUseCaseAuthorizationToRoleCommand;
import br.com.petrobras.security.command.management.authorization.roleusecase.RevokeUseCaseAuthorizationFromRoleCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IRoleUseCaseAuthorizationManager;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.UseCase;
import br.com.petrobras.security.model.authorization.configuration.RoleUseCaseAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class RoleUseCaseAuthorizationManagerCoreImpl
implements IRoleUseCaseAuthorizationManager {
    public List<RoleUseCaseAuthorization> findAll(Role role) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAll(role.getId());
    }

    public List<RoleUseCaseAuthorization> findAll(String roleId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)roleId);
        FindAllRoleUseCaseAuthorizationsByRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleUseCaseAuthorizationsByRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public void grant(Role role, UseCase useCase) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCase);
        this.grant(role.getId(), useCase.getId());
    }

    public void grant(String roleId, String useCaseId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)roleId);
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCaseId);
        GrantUseCaseAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantUseCaseAuthorizationToRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setUseCaseIdArg(useCaseId);
        cmd.execute();
    }

    public void revoke(Role role, UseCase useCase) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCase);
        this.revoke(role.getId(), useCase.getId());
    }

    public void revoke(String roleId, String useCaseId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)roleId);
        Validator.throwInvalidArgumentExceptionIfNull((Object)useCaseId);
        RevokeUseCaseAuthorizationFromRoleCommand cmd = ICommandIdentifier.getInstance().getRevokeUseCaseAuthorizationFromRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setUseCaseIdArg(useCaseId);
        cmd.execute();
    }
}

