/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.basic;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.basic.usergroup.FindAllUserGroupsCommand;
import br.com.petrobras.security.command.management.basic.usergroup.FindUserGroupByIdCommand;
import br.com.petrobras.security.command.management.basic.usergroup.FindUserGroupsByIdsCommand;
import br.com.petrobras.security.command.management.basic.usergroup.RemoveUserGroupCommand;
import br.com.petrobras.security.command.management.basic.usergroup.SaveUserGroupCommand;
import br.com.petrobras.security.command.management.basic.usergroup.UpdateUserGroupCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.basic.IUserGroupManager;
import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class UserGroupManagerCoreImpl
implements IUserGroupManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public void save(UserGroup userGroup) throws PermissionDeniedException, InvalidOperationException, InvalidArgumentException, SecurityException {
        SaveUserGroupCommand cmd = ICommandIdentifier.getInstance().getSaveUserGroupCommand();
        cmd.setUserGroupArg(userGroup);
        cmd.execute();
    }

    public void update(UserGroup userGroup) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        UpdateUserGroupCommand cmd = ICommandIdentifier.getInstance().getUpdateUserGroupCommand();
        cmd.setUserGroupArg(userGroup);
        cmd.execute();
    }

    public void update(String oldId, UserGroup userGroup) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        UpdateUserGroupCommand cmd = ICommandIdentifier.getInstance().getUpdateUserGroupCommand();
        cmd.setUserGroupArg(userGroup);
        cmd.setOldIdArg(oldId);
        cmd.execute();
    }

    public void remove(UserGroup userGroup) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        this.remove(userGroup.getId());
    }

    public void remove(String userGroupId) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        RemoveUserGroupCommand cmd = ICommandIdentifier.getInstance().getRemoveUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.execute();
    }

    public List<UserGroup> findAll() throws PermissionDeniedException, SecurityException {
        FindAllUserGroupsCommand cmd = ICommandIdentifier.getInstance().GetFindAllUserGroupsCommand();
        return (List)cmd.execute();
    }

    public UserGroup find(String id) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindUserGroupByIdCommand cmd = ICommandIdentifier.getInstance().GetFindUserGroupByIdCommand();
        cmd.setUserGroupIdArg(id);
        return (UserGroup)cmd.execute();
    }

    public List<UserGroup> find(List<String> ids) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindUserGroupsByIdsCommand cmd = ICommandIdentifier.getInstance().GetFindUserGroupsByIdsCommand();
        cmd.setUserGroupsIdsArg(ids);
        return (List)cmd.execute();
    }
}

