/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.enterprise;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.enterprise.department.FindAllActiveDepartmentsCommand;
import br.com.petrobras.security.command.management.enterprise.department.FindAllDepartmentsCommand;
import br.com.petrobras.security.command.management.enterprise.department.FindDepartmentByAcronymCommand;
import br.com.petrobras.security.command.management.enterprise.department.FindDepartmentByCodeCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.enterprise.IDepartmentManager;
import br.com.petrobras.security.model.Company;
import br.com.petrobras.security.model.Department;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class DepartmentManagerCoreImpl
implements IDepartmentManager {
    public Department find(Long code, Company company) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)company);
        return this.find(code, company.getCode());
    }

    public Department find(Long code, Long companyCode) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindDepartmentByCodeCommand cmd = ICommandIdentifier.getInstance().getFindDepartmentByCodeCommand();
        cmd.setCodeArg(code);
        cmd.setCompanyCodeArg(companyCode);
        return (Department)cmd.execute();
    }

    public Department find(String departmentAcronym, Company company) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)company);
        return this.find(departmentAcronym, company.getCode());
    }

    public Department find(String departmentAcronym, Long companyCode) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindDepartmentByAcronymCommand cmd = ICommandIdentifier.getInstance().getFindDepartmentByAcronymCommand();
        cmd.setDepartmentAcronymArg(departmentAcronym);
        cmd.setCompanyCodeArg(companyCode);
        return (Department)cmd.execute();
    }

    public List<Department> findAll() throws PermissionDeniedException, SecurityException {
        FindAllDepartmentsCommand cmd = ICommandIdentifier.getInstance().getFindAllDepartmentsCommand();
        return (List)cmd.execute();
    }

    public List<Department> findAllActive() throws PermissionDeniedException, SecurityException {
        FindAllActiveDepartmentsCommand cmd = ICommandIdentifier.getInstance().getFindAllActiveDepartmentsCommand();
        return (List)cmd.execute();
    }
}

