/*
 * Decompiled with CFR 0.152.
 */
package ControleAcesso;

import ControleAcesso.AutenticadorAD;
import ControleAcesso.AutenticadorWLS;
import ControleAcesso.CriptoCA;
import ControleAcesso.ModApoio;
import ControleAcesso.ModControleAcesso;
import ControleAcesso.ModControleDados;
import ControleAcesso.ModCorporativo;
import ControleAcesso.ModEstatistica;
import ControleAcesso.ModPermissao;
import ControleAcesso.ModPrincipal;
import ControleAcesso.ModRepositorio;
import ControleAcesso.Util;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import oracle.jdbc.driver.OracleDriver;

public class Main
implements Serializable {
    private static final long serialVersionUID = 4669421915426728577L;
    private boolean isAutenticacaoObrigatoria = false;
    private boolean sistemaAutenticado;
    private String senhaSistema;
    private static final ThreadLocal gerandoSessao;
    private static final ThreadLocal threadConnection;
    private ModPrincipal principal = null;
    private ModPermissao permissao = null;
    private ModControleDados dados = null;
    private ModCorporativo corp = null;
    private ModEstatistica estatistica = null;
    private ModControleAcesso ca = null;
    private ModRepositorio repositorio = null;
    private ModApoio apoio = null;
    private AutenticadorAD autenticadorAD = null;
    private String codigoSistema = "";
    private String usuarioLogado = "";
    private String sessaoUsuario = "";
    private boolean conexaoCA = false;
    private boolean usuarioAutenticado = false;
    private String stringJDBC = null;
    private static boolean comPoolConexoes;

    static {
        ThreadLocal<Boolean> tl = new ThreadLocal<Boolean>();
        tl.set(Boolean.FALSE);
        gerandoSessao = tl;
        threadConnection = new ThreadLocal();
        comPoolConexoes = false;
    }

    private Main(String codigoSistema) throws Exception {
        this.verificaCodigoSistema(codigoSistema);
        this.codigoSistema = codigoSistema.trim().toUpperCase();
        this.conexaoCA = true;
        ModApoio.setAmbienteAtual(ModApoio.getAmbientePadrao());
        this.verificaSistemaAmbiente();
        this.isAutenticacaoObrigatoria = this.AutenticacaoSistemaObrigatoria().equalsIgnoreCase("S");
    }

    private Main(String codigoSistema, Connection conexao) throws Exception {
        this.verificaCodigoSistema(codigoSistema);
        threadConnection.set(conexao);
        this.codigoSistema = codigoSistema.trim().toUpperCase();
        this.conexaoCA = false;
        ModApoio.setInstanciaAtual(Util.getInstanciaDaURL(conexao.getMetaData().getURL().substring(conexao.getMetaData().getURL().lastIndexOf("@") + 1)));
        this.verificaSistemaAmbiente();
        this.isAutenticacaoObrigatoria = this.AutenticacaoSistemaObrigatoria().equalsIgnoreCase("S");
    }

    private Main(String codigoSistema, String instancia) throws Exception {
        this.verificaCodigoSistema(codigoSistema);
        this.codigoSistema = codigoSistema.trim().toUpperCase();
        this.conexaoCA = true;
        ModApoio.setInstanciaAtual(instancia);
        this.verificaSistemaAmbiente();
        this.isAutenticacaoObrigatoria = this.AutenticacaoSistemaObrigatoria().equalsIgnoreCase("S");
    }

    private Main(String codigoSistema, String instancia, String stringJDBCCA) throws Exception {
        this.stringJDBC = stringJDBCCA;
        this.verificaCodigoSistema(codigoSistema);
        this.codigoSistema = codigoSistema.trim().toUpperCase();
        this.conexaoCA = true;
        ModApoio.setInstanciaAtual(instancia);
        this.verificaSistemaAmbiente();
        this.isAutenticacaoObrigatoria = this.AutenticacaoSistemaObrigatoria().equalsIgnoreCase("S");
    }

    public static Main createObject(String codigoSistema, Connection conexao) throws Exception {
        return new Main(codigoSistema, conexao);
    }

    public static Main createObjectConnect(String codigoSistema, String instancia) throws Exception {
        return new Main(codigoSistema, instancia);
    }

    public static Main createObjectSistema(String codigoSistema) throws Exception {
        return new Main(codigoSistema);
    }

    public static Main createObjectAmbiente(String codigoSistema, String ambiente) throws Exception {
        ModApoio.setAmbienteAtual(ambiente);
        return new Main(codigoSistema, ModApoio.getInstanciaAtual());
    }

    public static Main createObjectAmbiente(String codigoSistema, String ambiente, String stringJDBCCA) throws Exception {
        ModApoio.setAmbienteAtual(ambiente);
        return new Main(codigoSistema, ModApoio.getInstanciaAtual(), stringJDBCCA);
    }

    public String autenticarAD(String usuarioLogado, String senhaUsuario) throws Exception {
        if (this.isAutenticacaoObrigatoria && !this.sistemaAutenticado) {
            throw new Exception("A Autentica\u00e7\u00e3o do Sistema \"" + this.getCodigoSistema() + "\" \u00e9 obrigat\u00f3ria para a Inst\u00e2ncia \"" + ModApoio.getInstanciaAtual() + "\" do Ambiente \"" + ModApoio.getAmbienteAtual() + "\"  no Controle de Acesso v3.");
        }
        if (this.ValidarLenUsuInterno(usuarioLogado)) {
            this.usuarioAutenticado = this.getAutenticadorAD().validarCENPES(usuarioLogado, senhaUsuario);
            if (this.usuarioAutenticado) {
                this.usuarioLogado = usuarioLogado.trim().toUpperCase();
                this.getEstatistica().IncluirLogAutentica(usuarioLogado.trim(), "S", "USUARIO", "AD", "Sucesso na autentica\u00e7\u00e3o com o usu\u00e1rio: " + usuarioLogado.trim().toUpperCase());
                return "S";
            }
            this.getEstatistica().IncluirLogAutentica(usuarioLogado.trim(), "N", "USUARIO", "AD", "Falha na autentica\u00e7\u00e3o com o usu\u00e1rio: " + usuarioLogado.trim().toUpperCase());
            return "N";
        }
        this.usuarioAutenticado = false;
        this.usuarioLogado = "";
        return "N";
    }

    public String autenticarJEE(HttpServletRequest request, String chaveDoUsuario, String senhaDoUsuario) throws Exception {
        if (this.isAutenticacaoObrigatoria && !this.sistemaAutenticado) {
            throw new Exception("A Autentica\u00e7\u00e3o do Sistema \"" + this.getCodigoSistema() + "\" \u00e9 obrigat\u00f3ria para a Inst\u00e2ncia \"" + ModApoio.getInstanciaAtual() + "\" do Ambiente \"" + ModApoio.getAmbienteAtual() + "\"  no Controle de Acesso v3.");
        }
        if (!this.ValidarLenUsuInterno(chaveDoUsuario) && !this.ValidarLenUsuExterno(chaveDoUsuario)) {
            throw new Exception("Chave informada n\u00e3o corresponde a um tipo de chave interna ou externa.");
        }
        chaveDoUsuario = chaveDoUsuario.trim().toUpperCase();
        this.usuarioAutenticado = AutenticadorWLS.logon(request, chaveDoUsuario, senhaDoUsuario);
        if (this.usuarioAutenticado) {
            this.usuarioLogado = chaveDoUsuario;
            this.getEstatistica().IncluirLogAutentica(chaveDoUsuario, "S", "USUARIO", "JEE", "Sucesso na autentica\u00e7\u00e3o com o usu\u00e1rio: " + chaveDoUsuario);
            return "S";
        }
        this.getEstatistica().IncluirLogAutentica(chaveDoUsuario, "N", "USUARIO", "JEE", "Falha na autentica\u00e7\u00e3o com o usu\u00e1rio: " + chaveDoUsuario);
        return "N";
    }

    public String autenticarIntegrado() throws Exception {
        if (this.isAutenticacaoObrigatoria && !this.sistemaAutenticado) {
            throw new Exception("A Autentica\u00e7\u00e3o do Sistema \"" + this.getCodigoSistema() + "\" \u00e9 obrigat\u00f3ria para a Inst\u00e2ncia \"" + ModApoio.getInstanciaAtual() + "\" do Ambiente \"" + ModApoio.getAmbienteAtual() + "\"  no Controle de Acesso v3.");
        }
        this.usuarioAutenticado = this.ValidarLenUsuInterno(this.getUsuarioSO());
        if (this.usuarioAutenticado) {
            this.usuarioLogado = this.getUsuarioSO();
            this.getEstatistica().IncluirLogAutentica(this.getUsuarioSO(), "S", "USUARIO", "INTEGRADO", "");
            return "S";
        }
        this.usuarioLogado = "";
        String chaveUsuarioTruncada = this.getUsuarioSO().length() > 15 ? this.getUsuarioSO().substring(0, 14) : this.getUsuarioSO();
        this.getEstatistica().IncluirLogAutentica(chaveUsuarioTruncada, "N", "USUARIO", "INTEGRADO", "");
        return "N";
    }

    public String autenticarChave(String usuarioLogado) throws Exception {
        if (this.isAutenticacaoObrigatoria && !this.sistemaAutenticado) {
            throw new Exception("A Autentica\u00e7\u00e3o do Sistema \"" + this.getCodigoSistema() + "\" \u00e9 obrigat\u00f3ria para a Inst\u00e2ncia \"" + ModApoio.getInstanciaAtual() + "\" do Ambiente \"" + ModApoio.getAmbienteAtual() + "\"  no Controle de Acesso v3.");
        }
        if (usuarioLogado == null || usuarioLogado.trim().length() == 0) {
            throw new Exception("Nenhum usu\u00e1rio logado foi informado.");
        }
        this.usuarioAutenticado = this.ValidarLenUsuInterno(usuarioLogado);
        if (this.usuarioAutenticado) {
            this.usuarioLogado = usuarioLogado.trim().toUpperCase();
            this.getEstatistica().IncluirLogAutentica(usuarioLogado.trim(), "S", "USUARIO", "CHAVE", "Sucesso na autentica\u00e7\u00e3o com o usu\u00e1rio: " + usuarioLogado.trim().toUpperCase());
            return "S";
        }
        this.usuarioLogado = "";
        String chaveUsuarioTruncada = usuarioLogado.trim().length() > 15 ? usuarioLogado.trim().substring(0, 14) : usuarioLogado;
        this.getEstatistica().IncluirLogAutentica(chaveUsuarioTruncada, "N", "USUARIO", "CHAVE", "Falha na autentica\u00e7\u00e3o com o usu\u00e1rio: " + usuarioLogado.trim().toUpperCase());
        return "N";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String autenticarUsuarioCa(String usuarioLogado, String senhaUsuario) throws Exception {
        String retorno;
        if (this.isAutenticacaoObrigatoria && !this.sistemaAutenticado) {
            throw new Exception("A Autentica\u00e7\u00e3o do Sistema \"" + this.getCodigoSistema() + "\" \u00e9 obrigat\u00f3ria para a Inst\u00e2ncia \"" + ModApoio.getAmbienteAtual() + "\" do Ambiente \"" + ModApoio.getAmbienteAtual() + "\"  no Controle de Acesso v3.");
        }
        if (usuarioLogado == null) throw new Exception("Nenhum usu\u00e1rio logado foi informado.");
        if (usuarioLogado.trim().length() == 0) {
            throw new Exception("Nenhum usu\u00e1rio logado foi informado.");
        }
        if (!this.ValidarLenUsuExterno(usuarioLogado)) {
            this.usuarioAutenticado = false;
            this.usuarioLogado = "";
            return "N";
        }
        try {
            try {
                CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_APOIO.FUN_AUTENTICAR_USUARIO_CA(?, ?, ?) }");
                cstmt.registerOutParameter(1, 1);
                cstmt.setString(2, this.getCodigoSistema());
                cstmt.setString(3, usuarioLogado);
                cstmt.setString(4, senhaUsuario);
                cstmt.execute();
                retorno = (String)cstmt.getObject(1);
                cstmt.close();
                if (retorno.equalsIgnoreCase("S")) {
                    this.usuarioAutenticado = true;
                    this.usuarioLogado = usuarioLogado.trim();
                } else {
                    this.usuarioAutenticado = false;
                    this.usuarioLogado = "";
                }
            }
            catch (Exception e) {
                String retorno2 = "N";
                this.usuarioLogado = "";
                this.usuarioAutenticado = false;
                throw new Exception("N\u00e3o foi poss\u00edvel Autenticar o Usu\u00e1rio no Controle de Acesso.\r\n" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.fecharConexaoCA();
            throw throwable;
        }
        {
            Object var5_9 = null;
            this.fecharConexaoCA();
            return retorno;
        }
    }

    private String AutenticacaoSistemaObrigatoria() throws Exception {
        String string;
        try {
            CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_APOIO.FUN_VERIF_AUTENT_SIST_OBRIG(?, ?, ?) }");
            cstmt.registerOutParameter(1, 1);
            cstmt.setString(2, this.getCodigoSistema());
            cstmt.setString(3, ModApoio.getAmbienteAtual());
            cstmt.setString(4, ModApoio.getInstanciaAtual());
            cstmt.execute();
            String obrigatoria = (String)cstmt.getObject(1);
            cstmt.close();
            string = obrigatoria;
            Object var3_5 = null;
        }
        catch (Exception e) {
            try {
                throw new Exception("N\u00e3o foi poss\u00edvel verificar se a Autentica\u00e7\u00e3o do Sistema \u00e9 Obrigat\u00f3ria.\r\n" + e.getMessage());
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.fecharConexaoCA();
                throw throwable;
            }
        }
        this.fecharConexaoCA();
        return string;
    }

    public String autenticarSistema(String senha) throws Exception {
        if (!this.sistemaAutenticado) {
            String string;
            try {
                try {
                    CriptoCA cript = new CriptoCA(1);
                    senha = cript.decriptar(senha, this.getCodigoSistema(), ModApoio.getAmbienteAtual(), ModApoio.getRegionalAtual());
                }
                catch (Exception cript) {
                    // empty catch block
                }
                String autenticado = "";
                CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_APOIO.FUN_AUTENTICAR_SISTEMA(?, ?)}");
                cstmt.registerOutParameter(1, 1);
                cstmt.setString(2, this.getCodigoSistema());
                cstmt.setString(3, senha);
                cstmt.execute();
                autenticado = (String)cstmt.getObject(1);
                cstmt.close();
                this.sistemaAutenticado = autenticado.equalsIgnoreCase("S");
                if (this.sistemaAutenticado) {
                    this.senhaSistema = senha;
                }
                string = autenticado;
                Object var4_7 = null;
            }
            catch (Exception e) {
                try {
                    Object var4_8 = null;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    this.fecharConexaoCA();
                    throw throwable;
                }
                this.fecharConexaoCA();
                return "";
            }
            this.fecharConexaoCA();
            return string;
        }
        throw new Exception("O Sistema j\u00e1 se encontra Autenticado no Controle de Acesso.");
    }

    private void gerarSessaoSistemaNoBanco(Connection connection) throws Exception {
        try {
            gerandoSessao.set(Boolean.TRUE);
            String autenticado = "";
            CallableStatement cstmt = connection.prepareCall("{? = call PKG_APOIO.FUN_GERAR_AUTENTICACAO(?, ?)}");
            cstmt.registerOutParameter(1, 1);
            cstmt.setString(2, this.getCodigoSistema());
            cstmt.setString(3, this.senhaSistema);
            cstmt.execute();
            autenticado = (String)cstmt.getObject(1);
            cstmt.close();
            if (!autenticado.equalsIgnoreCase("S")) {
                throw new Exception("A Senha do Sistema informada \u00e9 inv\u00e1lida.");
            }
            gerandoSessao.set(Boolean.FALSE);
        }
        catch (Exception e) {
            throw new Exception("Ocorreu um erro ao Gerar a Sess\u00e3oo Autenticada do Sistema no Banco de Dados." + e);
        }
    }

    public ModPrincipal getPrincipal() throws Exception {
        this.verificaAutenticacaoUsuario();
        if (this.principal == null) {
            this.principal = new ModPrincipal(this);
            return this.principal;
        }
        return this.principal;
    }

    public ModPermissao getPermissao() throws Exception {
        this.verificaAutenticacaoUsuario();
        if (this.permissao == null) {
            this.permissao = new ModPermissao(this);
            return this.permissao;
        }
        return this.permissao;
    }

    public ModControleDados getDados() throws Exception {
        this.verificaAutenticacaoUsuario();
        if (this.dados == null) {
            this.dados = new ModControleDados(this);
            return this.dados;
        }
        return this.dados;
    }

    public ModCorporativo getCorp() throws Exception {
        this.verificaAutenticacaoUsuario();
        if (this.corp == null) {
            this.corp = new ModCorporativo(this);
            return this.corp;
        }
        return this.corp;
    }

    public ModEstatistica getEstatistica() throws Exception {
        if (this.estatistica == null) {
            this.estatistica = new ModEstatistica(this);
            return this.estatistica;
        }
        return this.estatistica;
    }

    public ModControleAcesso getCA() throws Exception {
        this.verificaAutenticacaoUsuario();
        if (this.ca == null) {
            this.ca = new ModControleAcesso(this);
            return this.ca;
        }
        return this.ca;
    }

    public ModRepositorio getRepositorio() throws Exception {
        this.verificaAutenticacaoUsuario();
        if (this.repositorio == null) {
            this.repositorio = new ModRepositorio(this);
            return this.repositorio;
        }
        return this.repositorio;
    }

    public ModApoio getApoio() throws Exception {
        if (this.apoio == null) {
            this.apoio = new ModApoio(this);
            return this.apoio;
        }
        return this.apoio;
    }

    public AutenticadorAD getAutenticadorAD() throws Exception {
        if (this.autenticadorAD == null) {
            this.autenticadorAD = new AutenticadorAD(this);
            return this.autenticadorAD;
        }
        return this.autenticadorAD;
    }

    /*
     * Unable to fully structure code
     */
    protected Connection getConexao() throws Exception {
        connection = (Connection)Main.threadConnection.get();
        if (this.conexaoCA) {
            if (Main.comPoolConexoes) {
                try {
                    if (connection != null) ** GOTO lbl16
                    initialContext = new InitialContext();
                    dataSource = (DataSource)initialContext.lookup(ModApoio.getNomePoolConexoes());
                    connection = dataSource.getConnection();
                    Main.threadConnection.set(connection);
                }
                catch (Exception e) {
                    throw new Exception("Erro ao utilizar o Pool de Conex\u00f5es." + e);
                }
            } else if (connection == null) {
                connection = this.connectionFactory();
                Main.threadConnection.set(connection);
            }
lbl16:
            // 5 sources

            stm = connection.createStatement();
            stm.execute("SET ROLE " + ModApoio.getNomeRoleConexaoComBD() + " IDENTIFIED BY " + ModApoio.getSenhaRoleConexaoComBD());
            stm.execute("ALTER SESSION SET CURRENT_SCHEMA = " + ModApoio.getOwnerBD());
            stm.execute("ALTER SESSION SET NLS_DATE_FORMAT='DD/MM/YYYY'");
            stm.execute("ALTER SESSION SET NLS_NUMERIC_CHARACTERS = ',.'");
            if (ModApoio.withLogOracle()) {
                stm.execute("BEGIN SYS.DBMS_APPLICATION_INFO.SET_MODULE('SISCAC', 'Sistema Cliente: " + this.getCodigoSistema() + "'); END;");
            }
            stm.close();
        } else if (connection.isClosed()) {
            exception = new Exception("Erro ao recuperar a conexao do Controle de Acesso.\nA Conex\u00e3oo que voc\u00ea passou estava fechada.");
            throw exception;
        }
        if (this.sistemaAutenticado && this.isAutenticacaoObrigatoria && !this.getFlagGerandoSessao()) {
            this.gerarSessaoSistemaNoBanco(connection);
        }
        return connection;
    }

    private Connection connectionFactory() throws Exception {
        Connection connection = null;
        DriverManager.registerDriver((Driver)new OracleDriver());
        connection = DriverManager.getConnection(this.getStringJDBC(), ModApoio.getLoginConexaoComBD(), ModApoio.getSenhaConexaoComBD());
        return connection;
    }

    protected void fecharConexaoCA() throws SQLException {
        Connection connection = (Connection)threadConnection.get();
        threadConnection.set(null);
        try {
            if (this.conexaoCA && !this.getFlagGerandoSessao() && connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ComPoolConexoes(String FlagComPoolConexoes) {
        comPoolConexoes = FlagComPoolConexoes.equals("S");
    }

    public static void UsarPoolConexoes(String FlagComPoolConexoes) {
        comPoolConexoes = FlagComPoolConexoes.equals("S");
    }

    public static String DefinirNomePoolConexoes(String nomePoolConexoes) {
        if (nomePoolConexoes != null && nomePoolConexoes.trim().length() > 0) {
            ModApoio.setNomePoolConexoes(nomePoolConexoes);
            comPoolConexoes = true;
            return "S";
        }
        return "N";
    }

    protected String getUsuarioLogado() {
        return this.usuarioLogado.trim().toUpperCase();
    }

    protected String getNomeMaquina() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e2) {
            Object e2 = null;
            return "";
        }
    }

    protected String getSessaoUsuario() throws Exception {
        if (this.sessaoUsuario.trim().length() == 0) {
            this.sessaoUsuario = this.getPermissao().Valor_Sessao();
        }
        return this.sessaoUsuario;
    }

    protected String getCodigoSistema() {
        return this.codigoSistema;
    }

    protected String getStringJDBC() throws Exception {
        String stringJDBC = null;
        stringJDBC = this.stringJDBC == null ? ModApoio.getStringJDBC() : this.stringJDBC;
        return stringJDBC;
    }

    private void verificaAutenticacaoUsuario() throws Exception {
        if (!this.usuarioAutenticado) {
            throw new Exception("O Usu\u00e1rio deve ser autenticado ap\u00f3s a cria\u00e7\u00e3o da Instancia do Objeto Controle de Acesso.");
        }
    }

    private void verificaCodigoSistema(String codigoSistema) throws Exception {
        if (codigoSistema.equals(null) || codigoSistema.trim().length() == 0) {
            throw new Exception("O Codigo do Sistema n\u00e3o foi informado.");
        }
    }

    private void verificaSistemaAmbiente() throws Exception {
        String valido = null;
        try {
            CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_APOIO.FUN_VERIF_SISTEMA_VALIDO(?, ?, ?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.setString(2, this.getCodigoSistema());
            cstmt.setString(3, ModApoio.getAmbienteAtual());
            cstmt.setString(4, ModApoio.getInstanciaAtual());
            cstmt.execute();
            valido = (String)cstmt.getObject(1);
            cstmt.close();
        }
        catch (Exception ex) {
            throw new Exception("N\u00e3o foi poss\u00edvel verificar se o C\u00f3digo do Sistema \u00e9 v\u00e1lido.\n" + ex);
        }
        if (valido.equalsIgnoreCase("N")) {
            throw new Exception("O Sistema informado n\u00e3o existe no Ambiente '" + ModApoio.getAmbienteAtual() + "'.");
        }
    }

    private boolean ValidarLenUsuExterno(String usuarioExterno) {
        if (usuarioExterno == null) {
            return false;
        }
        return usuarioExterno.trim().length() >= 10 && usuarioExterno.trim().length() <= 15;
    }

    private boolean ValidarLenUsuInterno(String usuarioInterno) {
        if (usuarioInterno == null) {
            return false;
        }
        return usuarioInterno.trim().length() >= 4 && usuarioInterno.trim().length() <= 15;
    }

    private String getUsuarioSO() throws Exception {
        String usuarioSO = "";
        this.usuarioLogado = System.getProperty("user.name").toUpperCase();
        usuarioSO = this.usuarioLogado;
        if (usuarioSO == null || usuarioSO.trim().length() == 0) {
            throw new Exception("O Usu\u00e1rio Logado n\u00e3o pode ser capturado.");
        }
        return usuarioSO;
    }

    private boolean getFlagGerandoSessao() {
        if (gerandoSessao == null) {
            return false;
        }
        if (gerandoSessao.get() == null) {
            return false;
        }
        return (Boolean)gerandoSessao.get();
    }

    public String CapturaUsuario() throws Exception {
        this.verificaAutenticacaoUsuario();
        return this.usuarioLogado;
    }

    public String UserName() throws Exception {
        this.verificaAutenticacaoUsuario();
        return this.usuarioLogado;
    }

    public String CodigoSistema() throws Exception {
        this.verificaAutenticacaoUsuario();
        return this.codigoSistema;
    }

    public String Dominio() throws Exception {
        this.verificaAutenticacaoUsuario();
        try {
            this.getAutenticadorAD();
            return AutenticadorAD.pegarDominio(this.CapturaUsuario());
        }
        catch (Exception e2) {
            Object e2 = null;
            return null;
        }
    }

    public String NomeMaquina() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e2) {
            Object e2 = null;
            return "";
        }
    }

    public String SessaoUsuario() throws Exception {
        if (this.sessaoUsuario.trim().length() == 0) {
            this.sessaoUsuario = this.getPermissao().Valor_Sessao();
        }
        return this.sessaoUsuario;
    }

    public String LinkCA(String codigoPerfil) throws Exception {
        this.verificaAutenticacaoUsuario();
        String retorno = "";
        String[] descricaoMetodo = new String[]{"objCA.LinkCA", "Retorna o link do Controle de Acesso com os filtros de Sistema, Instancia, e Perfil(Opcional)"};
        if (codigoPerfil == null) {
            codigoPerfil = "";
        }
        try {
            String ambiente = String.valueOf(((Vector)this.getPrincipal().AmbienteSistInst(ModApoio.getInstanciaAtual()).get(0)).get(0)).trim();
            retorno = String.valueOf(String.valueOf(this.getApoio().getLinkConsole()) + "?sistema=" + this.codigoSistema + "&perfil=" + codigoPerfil + "&instancia=" + ModApoio.getInstanciaAtual() + "&ambiente=" + ambiente + "&regiao=" + this.getApoio().getRegiaoSistema(this.codigoSistema));
        }
        catch (Exception ex2) {
            this.exceptionHandler(descricaoMetodo, ex2);
            Object ex2 = null;
        }
        return retorno;
    }

    public static String VersaoAPI() {
        return ModApoio.getVersaoAPI();
    }

    public static String RegionalAPI() throws Exception {
        return ModApoio.getRegionalAtual();
    }

    public static String DefinirRegionalAPI(String siglaRegional) {
        try {
            ModApoio.setRegionalAtual(siglaRegional);
            return "S";
        }
        catch (Exception se) {
            return "N";
        }
    }

    public boolean Converter(String valor) {
        return valor.trim().equalsIgnoreCase("S");
    }

    public String UsuarioAutenticado() {
        if (this.usuarioAutenticado) {
            return "S";
        }
        return "N";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String EsqueciSenha(String ChaveUsuario) throws Exception {
        String retorno = null;
        String[] descricaoMetodo = new String[]{"EsqueciSenha", "M\u00e9todo que gera uma nova senha tempor\u00e1ria de acesso para o Usu\u00e1rio Externo de um determinado Sistema, caso haja necessidade. Esta nova senha \u00e9 enviada para o email do Usu\u00e1rio solicitante cadastrado em suas Informa\u00e7\u00e3oes Complementares."};
        try {
            try {
                CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_PRINC_03.FUN_ESQUECI_SENHA(?, ?, ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.setString(2, this.getCodigoSistema());
                cstmt.setString(3, ChaveUsuario);
                cstmt.setString(4, "INTERFACE JAVA");
                cstmt.execute();
                retorno = (String)cstmt.getObject(1);
                cstmt.close();
            }
            catch (Exception e) {
                this.exceptionHandler(descricaoMetodo, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fecharConexaoCA();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.fecharConexaoCA();
        return retorno;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String EmailUsuario(String ChaveUsuario) throws Exception {
        String retorno = null;
        String[] descricaoMetodo = new String[]{"EmailUsuario", "M\u00e9todo que retorna o e-mail de um usu\u00e1rio."};
        try {
            try {
                CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_PRINC_03.FUN_EMAIL_USUARIO(?, ?, ?, ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.setString(2, this.getCodigoSistema());
                cstmt.setString(3, this.getUsuarioLogado());
                cstmt.setString(4, ChaveUsuario);
                cstmt.setString(5, "INTERFACE JAVA");
                cstmt.execute();
                retorno = (String)cstmt.getObject(1);
                cstmt.close();
            }
            catch (Exception e) {
                this.exceptionHandler(descricaoMetodo, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fecharConexaoCA();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.fecharConexaoCA();
        return retorno;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String EsqueciSenhaEmail(String ChaveUsuario, String Email) throws Exception {
        String retorno = null;
        String[] descricaoMetodo = new String[]{"EsqueciSenhaEmail", "M\u00e9todo que gera uma nova senha tempor\u00e1ria de acesso para o Usu\u00e1rio Externo de um determinado Sistema. A nova senha ser\u00e1 enviada para o email do Usu\u00e1rio somente se o email informado for realmente do usu\u00e1rio."};
        try {
            try {
                CallableStatement cstmt = this.getConexao().prepareCall("{? = call PKG_PRINC_03.FUN_ESQUECI_SENHA_EMAIL(?, ?, ?, ?)}");
                cstmt.registerOutParameter(1, 12);
                cstmt.setString(2, this.getCodigoSistema());
                cstmt.setString(3, ChaveUsuario);
                cstmt.setString(4, Email);
                cstmt.setString(5, "INTERFACE JAVA");
                cstmt.execute();
                retorno = (String)cstmt.getObject(1);
                cstmt.close();
            }
            catch (Exception e) {
                this.exceptionHandler(descricaoMetodo, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.fecharConexaoCA();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.fecharConexaoCA();
        return retorno;
    }

    protected void exceptionHandler(String[] descricaoMetodo, Exception erro) throws Exception {
        String textoErro = new String();
        textoErro = String.valueOf(textoErro) + "\n************************************************************************\n";
        textoErro = String.valueOf(textoErro) + "\nExceptionHandler do Controle de Acesso:\n";
        textoErro = String.valueOf(textoErro) + "Foi gerado um erro durante a execu\u00e7\u00e3o do m\u00e9todo " + descricaoMetodo[0] + " do Controle de Acesso.\n";
        textoErro = String.valueOf(textoErro) + "Descri\u00e7\u00e3o do m\u00e9todo :\n";
        textoErro = String.valueOf(textoErro) + descricaoMetodo[1] + "\n";
        textoErro = String.valueOf(textoErro) + "Por favor, verifique os par\u00e2metros informados e tente novamente.\n";
        textoErro = String.valueOf(textoErro) + "\nPropriedades do Sistema:\n";
        textoErro = String.valueOf(textoErro) + "    - java.class.path: " + System.getProperty("java.class.path") + "\n";
        textoErro = String.valueOf(textoErro) + "    - java.version: " + System.getProperty("java.version") + "\n";
        textoErro = String.valueOf(textoErro) + "    - java.vm.version: " + System.getProperty("java.vm.version") + "\n";
        textoErro = String.valueOf(textoErro) + "    - java.library.path: " + System.getProperty("java.library.path") + "\n";
        textoErro = String.valueOf(textoErro) + "\nDados da API do Controle de Acesso Corporativo:\n";
        textoErro = String.valueOf(textoErro) + "    - Vers\u00e3o: " + ModApoio.getVersaoAPI() + "\n";
        textoErro = String.valueOf(textoErro) + "\n************************************************************************\n";
        erro.printStackTrace();
        throw new Exception(String.valueOf(textoErro) + erro.getMessage());
    }
}

