/*
 * ApplicationEnvironmentAuthorizerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authorization.IApplicationEnvironmentAuthorizerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;

/**
 * Implementao "SOAP" de um consumidor de autorizador de ambiente de
 * aplicao.
 * 
 * @author Phelipe Perboires - JGTL
 * @since 1.0
 * @version 1.0
 */
public class ApplicationEnvironmentAuthorizerConsumerSoapImpl implements
        IApplicationEnvironmentAuthorizerConsumer, Serializable {

    /* [ Constantes ] */

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -4376325392979882343L;

    /* [ Constantes ] */

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Operators ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.authorization.IApplicationEnvironmentAuthorizerConsumer#hasAnyAuthorization(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> hasAnyAuthorization(
            MessageHeader messageHeader, String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .isApplicationEnvironmentUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);        
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.authorization.IApplicationEnvironmentAuthorizerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<List<ApplicationEnvironment>> findAll(MessageHeader messageHeader, String userLogin, String regionalId, String environmentId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllAppEnvsAuthorizedToUserInEnvironment(smhDTO, regionalId, environmentId, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithApplicationEnvironmentListValue(srmwlvDTO, 
                        this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage());
    }
    
    /* [ Operators ] */

}

