/*
 * InformationValueAuthorizerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authorization.IInformationValueAuthorizerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ContextValueSetMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.server.service.soap.ContextValueSetDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * @author Rodrigo Carvalho - UPM7
 *
 */
public class InformationValueAuthorizerConsumerSoapImpl implements IInformationValueAuthorizerConsumer {

    private IUserContextIdentifier userContextIdentifier;
    
    @Override
    public ReturnMessage<Boolean> isAuthorized(MessageHeader messageHeader, String regionalId, String applicationCatalogId, String informationId, String informationValueId, String userLogin, boolean considerContext, ContextValueSet contextValuesSet) {

        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        ContextValueSetDTO contextValuesSetDTO = ContextValueSetMounter.mountTransferObject(contextValuesSet, getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
            .isInformationValueAuthorizedToUserInContext(smhDTO,
                    regionalId, applicationCatalogId,
                    informationId, informationValueId, userLogin, contextValuesSetDTO, considerContext);

        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    @Override
    public ReturnMessage<List<InformationValue>> findAllInformationValueAuthorizedToUser(MessageHeader messageHeader, String informationId, String userLogin, boolean considerContext, ContextValueSet contextValuesSet) {
        
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        ContextValueSetDTO contextValuesSetDTO = ContextValueSetMounter.mountTransferObject(contextValuesSet, getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllInformationValuesAuthorizedToUserInContext(smhDTO, informationId, userLogin, contextValuesSetDTO, considerContext);

        return ReturnMessageMounter.mountLocalObjectWithInformationValueListValue(rmDTO,
                getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }
}
