/*
 * RoleAuthorizerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.authorization.IRoleAuthorizerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ContextValueSetMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.io.Serializable;
import java.util.List;

/**
 * Implementao "SOAP" de um consumidor de autorizador em papel.
 */
public class RoleAuthorizerConsumerSoapImpl
implements
    IRoleAuthorizerConsumer,
    Serializable {

    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 772692847090932060L;

    /* [ Constantes ] */

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    @Override
    public ReturnMessage<List<Role>> findAllAuthorizedAndAdministrated(MessageHeader messageHeader, String userLogin) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findAllRolesAdministratedAndAuthorizedToUser(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<Boolean> isAuthorizedToUserGroup(MessageHeader messageHeader, String roleId, String userGroupId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
        .getCurrentEndPoint().isRoleAuthorizedToUserGroup(smhDTO, roleId, userGroupId);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);        
    }

    @Override
    public ReturnMessage<Boolean> isAuthorizedToEnterpriseGroup(MessageHeader messageHeader, String enterpriseGroupId, String roleId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .isRoleAuthorizedToEnterpriseGroup(smhDTO, roleId,
                        enterpriseGroupId);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO); 
    }

    @Override
    public ReturnMessage<List<Role>> findAllAuthorized(MessageHeader messageHeader, String userLogin, ContextValueSet contextValuesSet, boolean considerContext) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllRolesOfUserInContext(smhDTO, userLogin, ContextValueSetMounter.mountTransferObject(contextValuesSet, this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()), considerContext);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleListValue(
            rmDTO,
            this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
            this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    @Override
    public ReturnMessage<Boolean> isAuthorizedToUser(MessageHeader messageHeader, String userLogin, String roleId, ContextValueSet contextValuesSet, boolean considerContext) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().isRoleAuthorizedToUserInContext(smhDTO, roleId, userLogin, ContextValueSetMounter.mountTransferObject(contextValuesSet, this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()), considerContext);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

}
