package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IAreaManagementAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ExpirationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.model.authorization.basic.AreaManagementAuthorization;
import br.com.petrobras.security.server.service.soap.ExpirationDTO;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;
import org.apache.log4j.Logger;

import java.util.List;


/**
 * Implementao "SOAP" do consumidor do gerenciador de autorizao de gesto em rea.
 * 
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo
 *
 */
public class AreaManagementAuthorizationManagerConsumerSoapImpl implements
		IAreaManagementAuthorizationManagerConsumer {

	/* [ Logging ] */

	private static final Logger LOGGER = Logger.getLogger(AreaManagementAuthorizationManagerConsumerSoapImpl.class);

	/* [ Logging ] */
	
	/* [ Dependences ] */
	
	/**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }	

    /* [ Dependences ] */
    
    /* [ Operators ] */
    
    @Override
	public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
			String areaId, String userLogin, Expiration expiration,
			Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) {
		
    	LOGGER.info("Fazendo chamada para conceder autorizao de gesto em rea ao usurio usando consumidor de servio SOAP...");
    	
    	 // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter.mountTransferObject(expiration);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().grantAreaMngmntAuthToUser(
        		smhDTO, areaId, userLogin, expirationDTO, enabled, dataAuthorization, hierarchical);

        LOGGER.info("Fazendo chamada para conceder autorizao de gesto em rea ao usurio usando consumidor de servio SOAP...");
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
	}

	@Override
	public ReturnMessage<Boolean> grantOwnerOption(MessageHeader messageHeader,
			String areaId, String userLogin) {
		
		LOGGER.info("Fazendo chamada para conceder ao usurio o privilgio de proprietrio na autorizao de gesto em rea usando consumidor de servio SOAP...");
		
		 // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
        	.grantOwnerOptionToAreaMngmntAuth(smhDTO, areaId, userLogin);

        LOGGER.info("Fazendo chamada para conceder ao usurio o privilgio de proprietrio na autorizao de gesto em rea usando consumidor de servio SOAP...");
        
        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
	}

	@Override
	public ReturnMessage<Boolean> grantWithOwnerOption(
			MessageHeader messageHeader, String areaId, String userLogin,
			Expiration expiration, Boolean enabled, Boolean dataAuthorization,
			Boolean hierarchical) {
		
		LOGGER.info("Fazendo chamada para conceder a autorizao de gesto na rea com privilgio de proprietrio ao usurio usando consumidor de servio SOAP...");
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter.mountTransferObject(expiration);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
        	.grantAreaMngmntAuthOwnerOptToUser(smhDTO, areaId, userLogin, expirationDTO, enabled, dataAuthorization, hierarchical);

        LOGGER.info("Fazendo chamada para conceder a autorizao de gesto na rea com privilgio de proprietrio ao usurio usando consumidor de servio SOAP...");
        
        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
	}

	@Override
	public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
			String areaId, String userLogin) {
		
		LOGGER.info("Fazendo chamada para revogar autorizao de gesto em rea de usurio usando consumidor de servio SOAP...");
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
        	.revokeAreaMngmntAuthFromUser(smhDTO, areaId, userLogin);

        LOGGER.info("Fazendo chamada para revogar autorizao de gesto em rea de usurio usando consumidor de servio SOAP...");
        
        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
	}

	@Override
	public ReturnMessage<Boolean> revokeOwnerOption(
			MessageHeader messageHeader, String areaId, String userLogin) {

		LOGGER.info("Fazendo chamada para revogar o privilgio de proprietrio do usurio na autorizao de gesto em rea usando consumidor de servio SOAP...");
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
        	.revokeOwnerOptionFromAreaMngmntAuth(smhDTO, areaId, userLogin);

        LOGGER.info("Fazendo chamada para revogar o privilgio de proprietrio do usurio na autorizao de gesto em rea usando consumidor de servio SOAP...");
        
        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
	}

	@Override
	public ReturnMessage<Boolean> update(MessageHeader messageHeader,
			String areaId, String userLogin, Expiration expiration,
			Boolean enabled, Boolean dataAuthorization, Boolean hierarchical) {

		LOGGER.info("Fazendo chamada para atualizar a autorizao de gesto na rea usando consumidor de servio SOAP...");
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        ExpirationDTO expirationDTO = ExpirationMounter.mountTransferObject(expiration);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
        	.updateAreaMngmntAuthOfUser(smhDTO, areaId, userLogin, expirationDTO, enabled, dataAuthorization, hierarchical);

        LOGGER.info("Fazendo chamada para atualizar a autorizao de gesto na rea usando consumidor de servio SOAP...");
        
        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seebr.com.petrobras.security.consume.management.authorization.
	 * IAreaManagementAuthorizationManagerConsumer
	 * #find(br.com.petrobras.security.consume.MessageHeader, java.lang.String,
	 * java.lang.String)
	 */
	@Override
	public ReturnMessage<AreaManagementAuthorization> find(
			MessageHeader messageHeader, String areaId, String userLogin) {
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
		SoapMessageHeader smhDTO = MessageHeaderMounter
				.mountTransferObject(messageHeader);
		
		// Executa o servio SOAP.
		SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
				.findAreaMngmntAuthOfUser(smhDTO, areaId, userLogin);
		
		// Converte o retorno.
		return ReturnMessageMounter
				.mountLocalObjectWithAreaManagementAuthorizationValue(rmDTO,
						this.getUserContextIdentifier().getCurrentUserContext()
								.getPreferredUserLanguage(), this
								.getUserContextIdentifier()
								.getCurrentUserContext()
								.getSupportedApplicationLanguages());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seebr.com.petrobras.security.consume.management.authorization.
	 * IAreaManagementAuthorizationManagerConsumer
	 * #findAllInApplicationEnvironment
	 * (br.com.petrobras.security.consume.MessageHeader)
	 */
	@Override
	public ReturnMessage<List<AreaManagementAuthorization>> findAllInApplicationEnvironment(
			MessageHeader messageHeader) {
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
		SoapMessageHeader smhDTO = MessageHeaderMounter
				.mountTransferObject(messageHeader);
		
		// Executa o servio SOAP.
		SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
				.getCurrentEndPoint().findAllAreaMngmntAuthorizations(smhDTO);
		
		// Converte o retorno.
		return ReturnMessageMounter
				.mountLocalObjectWithAreaManagementAuthorizationListValue(
						rmDTO, this.getUserContextIdentifier()
								.getCurrentUserContext()
								.getPreferredUserLanguage(), this
								.getUserContextIdentifier()
								.getCurrentUserContext()
								.getSupportedApplicationLanguages());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seebr.com.petrobras.security.consume.management.authorization.
	 * IAreaManagementAuthorizationManagerConsumer
	 * #findAllInArea(br.com.petrobras.security.consume.MessageHeader,
	 * java.lang.String)
	 */
	@Override
	public ReturnMessage<List<AreaManagementAuthorization>> findAllInArea(
			MessageHeader messageHeader, String areaId) {

		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
		SoapMessageHeader smhDTO = MessageHeaderMounter
				.mountTransferObject(messageHeader);

		// Executa o servio SOAP.
		SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
				.getCurrentEndPoint().findAllAreaMngmntAuthorizationsOfArea(
						smhDTO, areaId);

		// Converte o retorno.
		return ReturnMessageMounter
				.mountLocalObjectWithAreaManagementAuthorizationListValue(
						rmDTO, this.getUserContextIdentifier()
								.getCurrentUserContext()
								.getPreferredUserLanguage(), this
								.getUserContextIdentifier()
								.getCurrentUserContext()
								.getSupportedApplicationLanguages());
	}

	/* [ Operators ] */
}
