/*
 * RoleInformationValueAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IRoleInformationValueAuthorizationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.model.authorization.information.RoleInformationValueAuthorization;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao "SOAP" de consumidor de gerenciador de autorizao de valor de informao em papel.
 *
 */
public class RoleInformationValueAuthorizationManagerConsumerSoapImpl implements
    IRoleInformationValueAuthorizationManagerConsumer {
    
    /* [ Constantes ] */

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }
    
    /* [ Dependences ] */

    /* [ Operators ] */
    
    public ReturnMessage<List<RoleInformationValueAuthorization>> findAllWithRole(MessageHeader messageHeader, String roleId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationValuesAuthorizationsOfRole(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleInformationValueAuthorizationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    public ReturnMessage<List<RoleInformationValueAuthorization>> findAllWithInformationValue(MessageHeader messageHeader, 
            String informationId, String informationValueId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllRolesAuthorizationsOfInformationValue(smhDTO, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleInformationValueAuthorizationListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleInformationValueAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String roleId, String informationId, String informationValueId)
            throws ObjectNotFoundException {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantInformationValueToRole(smhDTO, roleId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleInformationValueAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String roleId, String regionalId, String applicationCatalogId,
            String informationId, String informationValueId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantSharedInformationValueToRole(smhDTO, roleId, regionalId, applicationCatalogId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleInformationValueAuthorizationManagerConsumer#Revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String roleId, String informationId, String informationValueId)
            throws ObjectNotFoundException {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeInformationValueFromRole(smhDTO, roleId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleInformationValueAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String roleId, String regionalId, String applicationCatalogId,
            String informationId, String informationValueId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeSharedInformationValueFromRole(smhDTO, roleId, regionalId, applicationCatalogId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
    }

	public ReturnMessage<List<RoleInformationValueAuthorization>> findAllWithInformationValue(
			MessageHeader messageHeader, String regionalId,
			String applicationCatalogId, String informationId,
			String informationValueId) {
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllRolesAuthorizationsOfInformationValueInRegional
                	(smhDTO, regionalId, applicationCatalogId, informationId, informationValueId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleInformationValueAuthorizationListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
	}

    /* [ Operators ] */
    
}
