 /*
 * RoleResourceGroupAuthorizationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.authorization.IRoleResourceGroupAuthorizationManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.context.identification.IUserContextIdentifier;
 import br.com.petrobras.security.model.authorization.access.RoleResourceGroupAuthorization;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.io.Serializable;
 import java.util.List;

/**
 * Implementao "SOAP" de um consumidor de gerenciador de autorizao de papel
 * em grupo de recurso.
 * 
 * @author Patrezze - YMPD
 *
 */
public class RoleResourceGroupAuthorizationManagerConsumerSoapImpl implements
        IRoleResourceGroupAuthorizationManagerConsumer, Serializable {

    /* [ Constants ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 474515195577247525L;    
    
    /* [ Constants ] */
    
    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }
    
    /* [ Dependences ] */

    /* [ Operators ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceGroupAuthorizationManagerConsumer#findAllOfResourceGroup(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<RoleResourceGroupAuthorization>> findAllOfResourceGroup(
            MessageHeader messageHeader, String resourceGroupId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findAllRolesWithAuthorizationInResourceGroup(smhDTO,
                        resourceGroupId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleResourceGroupAuthorizationListValue(srmwlvDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceGroupAuthorizationManagerConsumer#findAllOfRole(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<RoleResourceGroupAuthorization>> findAllOfRole(
            MessageHeader messageHeader, String roleId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllResourceGroupAuthorizationsOfRole(
                        smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter
                .mountLocalObjectWithRoleResourceGroupAuthorizationListValue(srmwlvDTO, this
                        .getUserContextIdentifier().getCurrentUserContext()
                        .getPreferredUserLanguage(), this
                        .getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceGroupAuthorizationManagerConsumer#grant(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> grant(MessageHeader messageHeader,
            String resourceGroupId, String roleId) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantResourceGroupAuthorizationToRole(smhDTO, resourceGroupId,
                        roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.authorization.IRoleResourceGroupAuthorizationManagerConsumer#revoke(br.com.petrobras.security.consume.MessageHeader, java.lang.String, java.lang.String)
     */
    public ReturnMessage<Boolean> revoke(MessageHeader messageHeader,
            String resourceGroupId, String roleId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeResourceGroupAuthorizationFromRole(smhDTO,
                        resourceGroupId, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }
    
    /* [ Operators ] */

}
