/*
* @(#)RoleUseCaseAuthorizationConsumerSoapImpl.java
*
*/
/*
 * RoleUseCaseAuthorizationConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.authorization;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.authorization.IRoleUseCaseAuthorizationConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.model.authorization.configuration.RoleUseCaseAuthorization;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * Implementao do consumidor de gerenciador de autorizao de papel
 * em caso de uso.
 */
public class RoleUseCaseAuthorizationConsumerSoapImpl implements IRoleUseCaseAuthorizationConsumer {
   
    private static final long serialVersionUID = 1393766626846428501L;
    
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public ReturnMessage<List<RoleUseCaseAuthorization>> findAllRoleUseCaseAuthorizationsByRole(
            MessageHeader mh, String roleId) throws ObjectNotFoundException {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findAllUseCaseAuthorizationsOfRole(smhDTO, roleId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRoleUseCaseAuthorizationListValue(rmDTO, 
                this.getUserContextIdentifier().getCurrentUserContext()
                    .getPreferredUserLanguage(), 
                    this
                    .getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    public ReturnMessage<Boolean> grantUseCaseAuthorizationToRole(
            MessageHeader mh, String roleId, String useCaseId) 
        throws PermissionDeniedException, ObjectNotFoundException {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .grantUseCaseToRole(smhDTO, roleId, useCaseId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<Boolean> revokeUseCaseAuthorizationFromRole(
            MessageHeader mh, String roleId, String useCaseId)
        throws PermissionDeniedException, ObjectNotFoundException {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(mh);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .revokeUseCaseFromRole(smhDTO, roleId, useCaseId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

}

