/*
 * AreaManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.basic;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.basic.IAreaManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.AreaMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;
import org.apache.log4j.Logger;

import java.util.List;

public class AreaManagerConsumerSoapImpl implements IAreaManagerConsumer {

	/* [ Logging ] */

	private static final Logger LOGGER = Logger.getLogger(AreaManagerConsumerSoapImpl.class);

	/* [ Logging ] */
	
	/* [ Dependences ] */
	
	/**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */
    
    /* [ Operators ] */
	
	@Override
	public ReturnMessage<List<Area>> findAll(MessageHeader messageHeader) {
		
		LOGGER.info("Fazendo chamada para consulta de todas as reas usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().findAllAreas(smh);

        // Converte o retorno.
        ReturnMessage<List<Area>> rm = ReturnMessageMounter.mountLocalObjectWithAreaListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Chamada para consulta de todas as reas usando consumidor de servio SOAP feita.");

        return rm;
	}

	@Override
	public ReturnMessage<Area> findById(MessageHeader messageHeader, String areaId) {
		
		LOGGER.info("Fazendo chamada para consulta de rea por identificador usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().findAreaById(smh, areaId);

        // Converte o retorno.
        ReturnMessage<Area> rm = ReturnMessageMounter.mountLocalObjectWithAreaValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Chamada para consulta de rea por identificador usando consumidor de servio SOAP feita.");

        return rm;
	}

	@Override
	public ReturnMessage<List<Area>> findByIds(MessageHeader messageHeader,
			List<String> areaIds) {
		
		LOGGER.info("Fazendo chamada para consulta de reas a partir de identificadores usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().findAreasByIds(smh, areaIds);

        // Converte o retorno.
        ReturnMessage<List<Area>> rm = ReturnMessageMounter.mountLocalObjectWithAreaListValue(rmDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(),
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());

        LOGGER.info("Chamada para consulta de reas a partir de identificadores usando consumidor de servio SOAP feita.");

        return rm;
	}

	@Override
	public ReturnMessage<Boolean> removeById(MessageHeader messageHeader, String areaId) {
		LOGGER.info("Fazendo chamada para excluso de rea usando consumidor de servio SOAP...");
		
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().removeArea(smhDTO, areaId);

        LOGGER.info("Chamada para excluso de rea usando consumidor de servio SOAP feita.");
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
	}

	@Override
	public ReturnMessage<Boolean> save(MessageHeader messageHeader, Area area) {
		LOGGER.info("Fazendo chamada para incluso de rea usando consumidor de servio SOAP...");

		SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

		// 	Executa o servio SOAP.
		SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
        	.saveArea(smh,AreaMounter.mountTransferObject(area,
                		this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()));

		// Converte o retorno.
		ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

		LOGGER.info("Chamada para incluso de rea usando consumidor de servio SOAP feita.");

		return rm;
	}

	@Override
	public ReturnMessage<Boolean> update(MessageHeader messageHeader, Area areaWithUidLoaded) {
		
		LOGGER.info("Fazendo chamada para atualizao de rea usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().updateAreaWithUidLoaded(smh, 
            		AreaMounter.mountTransferObject(areaWithUidLoaded,
            				this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Chamada para atualizao de rea usando consumidor de servio SOAP feita.");

        return rm;
	}

	@Override
	public ReturnMessage<Boolean> update(MessageHeader messageHeader, String oldAreaId,
			Area areaToUpdate) {
		
		LOGGER.info("Fazendo chamada para atualizao de rea usando consumidor de servio SOAP...");

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().updateArea(smh, oldAreaId, 
        		AreaMounter.mountTransferObject(areaToUpdate,
        				this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages()));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        LOGGER.info("Chamada para atualizao de rea usando consumidor de servio SOAP feita.");

        return rm;
	}

}
