 /*
 * ExternalUserManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.basic;

 import br.com.petrobras.security.consume.MessageHeader;
 import br.com.petrobras.security.consume.ReturnMessage;
 import br.com.petrobras.security.consume.management.basic.IExternalUserManagerConsumer;
 import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ExternalUserMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
 import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
 import br.com.petrobras.security.context.identification.IUserContextIdentifier;
 import br.com.petrobras.security.model.ExternalUser;
 import br.com.petrobras.security.model.security.TokenUser;
 import br.com.petrobras.security.server.service.soap.ExternalUserDTO;
 import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
 import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

 import java.util.List;

/**
 * Implementao "SOAP" do consumidor de gerenciador de usurio externo.
 * 
 * @author Patrezze - YMPD
 * @since 3.0
 * @version 1.0
 */
public class ExternalUserManagerConsumerSoapImpl implements IExternalUserManagerConsumer {

    /* [ Dependences ] */

    /**
     * Identificador do contexto de usurio.
     */
    private IUserContextIdentifier userContextIdentifier;

    /**
     * Obtm o identificador do contexto de usurio.
     * 
     * @return Identificador do contexto de usurio.
     */
    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }

    /**
     * Define o identificador do contexto de usurio.
     * 
     * @param userContextIdentifier
     *            Identificador do contexto de usurio.
     */
    public void setUserContextIdentifier(
            IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    /* [ Dependences ] */

    /* [ Caso de Uso "Consultar usurio externo" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IExternalUserConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<ExternalUser>> findAll(MessageHeader messageHeader) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
        .mountTransferObject(messageHeader);
        
        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllExternalUsers(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithExternalUserListValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IExternalUserConsumer#findAllInApplicationEnvironment(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<ExternalUser>> findAllInApplicationEnvironment(
            MessageHeader messageHeader) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
        .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findAllExternalUsersInApplicationEnvironment(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithExternalUserListValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IExternalUserConsumer#findByLogin(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<ExternalUser> findByLogin(MessageHeader messageHeader, String userLogin) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
        .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findExternalUserByLogin(smhDTO, userLogin);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithExternalUserValue(rmDTO);
    }

    @Override
    public ReturnMessage<List<ExternalUser>> findAllByDocumentNumber(MessageHeader messageHeader, String userDocumentNumber) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllExternalUsersByDocumentNumber(smhDTO, userDocumentNumber);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithExternalUserListValue(rmDTO);
    }

    @Override
    public ReturnMessage<List<ExternalUser>> findAllByTextFilter(MessageHeader messageHeader, String textFilter) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint().findAllExternalUsersByTextFilter(smhDTO, textFilter);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithExternalUserListValue(rmDTO);
    }

/* [ Caso de Uso "Consultar usurio externo" ] */

    
    /* [ Caso de Uso "Excluir usurio externo" ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IExternalUserConsumer#remove(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> remove(MessageHeader messageHeader,
            String userLogin) {

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().removeExternalUser(smh, userLogin);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }
    
    /* [ Caso de Uso "Excluir usurio externo" ] */
    
    
    /* [ Caso de Uso "Incluir usurio externo" ] */

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IExternalUserConsumer#save(br.com.petrobras.security.consume.MessageHeader, br.com.petrobras.security.model.ExternalUser)
     */
    public ReturnMessage<Boolean> save(MessageHeader messageHeader,
            ExternalUser externalUser) {

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);

        ExternalUserDTO externalUserDTO = ExternalUserMounter.mountTransferObject(externalUser);
        
        // Executa o servio SOAP        
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().saveExternalUser(smh, externalUserDTO);
        
        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }
    
    /* [ Caso de Uso "Incluir usurio externo" ] */
    
    
    /* [ Caso de Uso "Atualizar usurio externo" ] */

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IExternalUserConsumer#update(br.com.petrobras.security.consume.MessageHeader, br.com.petrobras.security.model.ExternalUser)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            ExternalUser externalUser) {

        SoapMessageHeader smh = MessageHeaderMounter.mountTransferObject(messageHeader);
        
        ExternalUserDTO externalUserDTO = ExternalUserMounter.mountTransferObject(externalUser);
        
        // Executa o servio SOAP.
        SoapReturnMessage rmDTO =
            ConsumeSoapUtil.getCurrentEndPoint().updateExternalUser(smh, externalUserDTO);
        
        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }
    
    /* [ Caso de Uso "Atualizar usurio externo" ] */
    
    public ReturnMessage<TokenUser> updatePassword(String regionalId, String environmentId, String applicationCatalogId, String applicationPassword, String externalUserLogin, String oldPassword, String newPassword) {
     
        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
          .logonAndUpdatePasswordFromExternalUser(null, regionalId, environmentId, applicationCatalogId, applicationPassword, externalUserLogin, oldPassword, newPassword);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithTokenUserValue(srmDTO);
    }

	public ReturnMessage<Boolean> generateNewPassword(MessageHeader messageHeader, String externalUserLogin) {
		  // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmDTO = ConsumeSoapUtil.getCurrentEndPoint()
          .generateNewPasswordToExternalUser(smhDTO, externalUserLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(srmDTO);
	}
    
}
