/*
 * InformationManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.information;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.information.IInformationManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.InformationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.InformationSharingTypeEnumMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.InformationSharingType;
import br.com.petrobras.security.server.service.soap.*;

import java.util.List;

/**
 * Implementao SOAP da interface de consumo para gerenciamento de informaes.
 * 
 * @author Rodrigo Carvalho - UPM7
 * @author Phelipe Perboires - JGTL
 * @since 2.0
 * @version 1.0
 *
 */
public class InformationManagerConsumerSoapImpl implements
        IInformationManagerConsumer {

    /* [ Dependencias ] */
    
    private IUserContextIdentifier userContextIdentifier;

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public IUserContextIdentifier getUserContextIdentifier() {
        return userContextIdentifier;
    }
    
    /* [ Dependencias ] */
    
    /* [ Operaes ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#findByUid(br.com.petrobras.security.consume.MessageHeader, java.lang.Long)
     */
    public ReturnMessage<Information> findByUid(MessageHeader messageHeader,
            Long informationUid) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findInformationByUid(smhDTO, informationUid);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValue(rmDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#findById(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Information> findById(MessageHeader messageHeader,
            String informationId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findInformationById(smhDTO, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValue(rmDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<Information>> findAll(MessageHeader messageHeader) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformations(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationListValue(srmwlvDTO, 
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#findByIds(br.com.petrobras.security.consume.MessageHeader, java.util.List)
     */
    public ReturnMessage<List<Information>> findByIds(
            MessageHeader messageHeader, List<String> informationsIds) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findInformationsById(smhDTO, informationsIds);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#findAllInformationSharingTypes(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<InformationSharingType>> findAllInformationSharingTypes(
            MessageHeader messageHeader) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationSharingTypes(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationSharingTypeListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#save(br.com.petrobras.security.consume.MessageHeader, br.com.petrobras.security.model.Information)
     */
    public ReturnMessage<Boolean> save(MessageHeader messageHeader,
            Information information) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        InformationDTO informationDTO = InformationMounter.mountTransferObject(information, 
                this.getUserContextIdentifier().getCurrentUserContext()
                    .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .saveInformation(smhDTO, informationDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#update(br.com.petrobras.security.consume.MessageHeader, java.lang.String, br.com.petrobras.security.model.Information)
     */
    public ReturnMessage<Boolean> update(MessageHeader messageHeader,
            String oldId, Information information) {
        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Converte o papel local em um papel de transferncia.
        InformationDTO informationDTO = InformationMounter.mountTransferObject(information, 
                this.getUserContextIdentifier().getCurrentUserContext()
                    .getSupportedApplicationLanguages());

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .updateInformation(smhDTO, oldId, informationDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.information.IInformationManagerConsumer#remove(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<Boolean> remove(MessageHeader messageHeader,
            String informationId) {

        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .removeInformation(smhDTO, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithBooleanValue(rmDTO);
    }

    public ReturnMessage<List<Information>> findAllInAllRegionals(MessageHeader messageHeader) {        
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationsInAllRegionals(smhDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }
    
    public ReturnMessage<Information> findByIdInRegional(MessageHeader messageHeader, String regionalId, String applicationCatalogIdOfInformationOwner, String informationId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findInformationByIdInRegional(smhDTO, regionalId, applicationCatalogIdOfInformationOwner, informationId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
    }

    public ReturnMessage<List<Information>> findAllWithSharingType(MessageHeader messageHeader, InformationSharingType sharingType) {
     
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        InformationSharingTypeEnumDTO sharingTypeDTO =
            InformationSharingTypeEnumMounter.mountTransferObject(sharingType);
        
        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationsWithSharingFilter(smhDTO, sharingTypeDTO);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
        
    }

	public ReturnMessage<List<Information>> findAllInRegional(MessageHeader messageHeader, String regionalId) {
		// Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllInformationsInRegional(smhDTO, regionalId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithInformationListValue(srmwlvDTO,
                this.getUserContextIdentifier().getCurrentUserContext().getPreferredUserLanguage(), 
                this.getUserContextIdentifier().getCurrentUserContext().getSupportedApplicationLanguages());
	}
    
    /* [ Operaes ] */
    
}
