/*
 * ChangeNotificationConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.util;

import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.NotificationRegistrationMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.consume.util.IChangeNotificationConsumer;
import br.com.petrobras.security.model.util.NotificationRegistration;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;

/**
 * @author Rodrigo Carvalho - UPM7
 *
 */
public class ChangeNotificationConsumerSoapImpl implements IChangeNotificationConsumer {

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.util.IChangeNotificationConsumer#registerNotifier(java.lang.String, java.lang.String, java.lang.String, java.lang.String, br.com.petrobras.security.model.util.NotificationRegistration)
     */
    public ReturnMessage<Boolean> registerNotifier(String regionalId,
            String environmentId, String applicationCatalogId,
            String applicationPassword,
            NotificationRegistration notificationRegistration) {

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .registerChangeNotifier(null, regionalId, environmentId, applicationCatalogId,
                        applicationPassword, NotificationRegistrationMounter.mountTransferObject(notificationRegistration));

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.util.IChangeNotificationConsumer#registerNotifier(java.lang.String, java.lang.String, java.lang.String, java.lang.String, br.com.petrobras.security.model.util.NotificationRegistration)
     */
    public ReturnMessage<Boolean> unregisterNotifier(String regionalId,
            String environmentId, String applicationCatalogId,
            String applicationPassword) {

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .unregisterChangeNotifier(null, regionalId, environmentId,
                        applicationCatalogId, applicationPassword);

        // Converte o retorno.
        ReturnMessage<Boolean> rm = ReturnMessageMounter
                .mountLocalObjectWithBooleanValue(rmDTO);

        return rm;
    }

}
