/*
 * DateMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.util.Calendar;
import java.util.Date;

public class DateMounter {

    public static Date mountLocalObject(XMLGregorianCalendar calendar) {
        if (calendar == null) {
            return null;
        }

        return calendar.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar mountTransferObject(Date date)
            throws DatatypeConfigurationException {
        if (date == null) {
            return null;
        }

        Calendar cal = Calendar.getInstance();
        cal.setTime(date);

        XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();

        xmlGregorianCalendar.setDay(cal.get(Calendar.DAY_OF_MONTH));
        xmlGregorianCalendar.setMonth(cal.get(Calendar.MONTH) + 1);
        xmlGregorianCalendar.setYear(cal.get(Calendar.YEAR));
        xmlGregorianCalendar.setHour(cal.get(Calendar.HOUR_OF_DAY));
        xmlGregorianCalendar.setMinute(cal.get(Calendar.MINUTE));
        xmlGregorianCalendar.setSecond(cal.get(Calendar.SECOND));
        xmlGregorianCalendar.setMillisecond(cal.get(Calendar.MILLISECOND));

        return xmlGregorianCalendar;
    }

}

