/*
 * DepartmentMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Department;
import br.com.petrobras.security.server.service.soap.DepartmentDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador de lotao.
 *
 * @author Phelipe Perboires - JGTL, Eraldo Neto - HMGL
 * @version 1.0
 * @since 1.0
 */
public class DepartmentMounter {

    /**
     * Monta uma lotao do modelo a partir de uma lotao de transferncia.
     *
     * @param departmentDTO Lotao de transferncia.
     * @return Lotao do modelo.
     */
    public static Department mountLocalObject(DepartmentDTO departmentDTO) {
        if (departmentDTO == null) {
            return null;
        }

        Department department = new Department();

        department.setCode(departmentDTO.getCode());

        department.setAcronym(departmentDTO.getAcronym());
        department.setStatus(DepartmentStatusMounter.mountModelObject(departmentDTO.getStatus()));
        department.setCompany(CompanyMounter.mountLocalObject(departmentDTO.getCompany()));
        department.setCreationDate(DateMounter.mountLocalObject(departmentDTO.getCreationDate()));

        if (departmentDTO.getParentCode() != null) {
            department.setParent(new Department(departmentDTO.getParentCode()));
        }

        return department;
    }

    /**
     * Monta uma lotao de transferncia a partir de uma lotao do modelo.
     *
     * @param department Lotao do modelo.
     * @return Lotao de transferncia.
     */
    public static DepartmentDTO mountTransferObject(Department department) {
        if (department == null) {
            return null;
        }

        DepartmentDTO departmentDTO = new DepartmentDTO();

        departmentDTO.setCode(department.getCode());

        departmentDTO.setAcronym(department.getAcronym());
        departmentDTO.setStatus(DepartmentStatusMounter.mountTransferObject(department.getStatus()));
        departmentDTO.setCompany(CompanyMounter.mountTranferObject(department.getCompany()));

        try {
            departmentDTO.setCreationDate(DateMounter
                    .mountTransferObject(department.getCreationDate()));
        } catch (DatatypeConfigurationException dtce) {
            throw new InvalidOperationException(
                    "No foi possvel converter a data de cadastro do departamento para enviar ao servio. "
                            + dtce.getMessage());
        }

        if (department.getParent() != null) {
            departmentDTO.setParentCode(department.getParent().getCode());
        }

        return departmentDTO;

    }
}
