 /*
 * EnterpriseGroupInformationValueAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.information.EnterpriseGroupInformationValueAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupInformationValueAuthorizationDTO;

 import java.util.List;
 import java.util.Locale;

/**
 * Montador de autoriao de valor de informao para grupo corporativo.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class EnterpriseGroupInformationValueAuthorizationMounter {

    /**
     * Monta uma autorizao de valor de informao para grupo corporativo a
     * partir de uma autorizao de valor de informao para grupo corporativo
     * de transferncia.
     * 
     * @param enterpriseGroupInformationValueAuthorizationDTO Objeto de tranferencia.
     * @param preferredUserLanguage
     *            Idioma preferido do usurio.
     * @param supportedApplicationLanguages
     *            Idiomas suportados pela aplicao.
     * @return Objeto de modelo.
     */
    public static EnterpriseGroupInformationValueAuthorization mountLocalObject(
            EnterpriseGroupInformationValueAuthorizationDTO enterpriseGroupInformationValueAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (enterpriseGroupInformationValueAuthorizationDTO == null) { return null; }
        else
        {
            EnterpriseGroupInformationValueAuthorization enterpriseGroupInformationValueAuthorization = new EnterpriseGroupInformationValueAuthorization();

            enterpriseGroupInformationValueAuthorization.setUid(enterpriseGroupInformationValueAuthorizationDTO.getUid());
            enterpriseGroupInformationValueAuthorization.setCreationDate(DateMounter.mountLocalObject(enterpriseGroupInformationValueAuthorizationDTO.getCreationDate()));

            enterpriseGroupInformationValueAuthorization.setEnterpriseGroup(EnterpriseGroupMounter.mountLocalObject(
                    enterpriseGroupInformationValueAuthorizationDTO.getEnterpriseGroup(), preferredUserLanguage, supportedApplicationLanguages));
            
            enterpriseGroupInformationValueAuthorization.setInformationValue(InformationValueMounter.mountLocalObject(
                    enterpriseGroupInformationValueAuthorizationDTO.getInformationValue(), preferredUserLanguage, supportedApplicationLanguages));


            return enterpriseGroupInformationValueAuthorization;
        }
    }
    
}
