 /*
 * EnterpriseGroupMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.EnterpriseGroup;
 import br.com.petrobras.security.model.EnterpriseGroupDepartment;
 import br.com.petrobras.security.model.EnterpriseGroupFunction;
 import br.com.petrobras.security.model.EnterpriseGroupOccupation;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupDTO;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupDepartmentDTO;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupFunctionDTO;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupOccupationDTO;

 import javax.xml.datatype.DatatypeConfigurationException;
 import java.util.List;
 import java.util.Locale;

 /**
 * Montador de grupo corporativo.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class EnterpriseGroupMounter {

    public static EnterpriseGroupDTO mountTransferObject(EnterpriseGroup enterpriseGroup) {
        
        EnterpriseGroupDTO enterpriseGroupDTO = new EnterpriseGroupDTO();
        
        enterpriseGroupDTO.setUid(enterpriseGroup.getUid());
        enterpriseGroupDTO.setId(enterpriseGroup.getId());
        enterpriseGroupDTO.setUserType(EnterpriseGroupUserTypeMounter.mountTransferObject(enterpriseGroup.getUserType()));
        enterpriseGroupDTO.setNameTranslations(I18nStringMounter.mountTransferObject(enterpriseGroup.getNameTranslations()));
        enterpriseGroupDTO.setDescriptionTranslations(I18nStringMounter.mountTransferObject(enterpriseGroup.getDescriptionTranslations()));
        enterpriseGroupDTO.setApplicationEnvironment(ApplicationEnvironmentMounter.mountTransferObject(enterpriseGroup.getApplicationEnvironment()));
        enterpriseGroupDTO.setArea(AreaMounter.mountTransferObject(enterpriseGroup.getArea(), null));
        enterpriseGroupDTO.setExpiration(ExpirationMounter.mountTransferObject(enterpriseGroup.getExpiration()));
        
        try {
            enterpriseGroupDTO.setCreationDate(DateMounter.mountTransferObject(enterpriseGroup.getCreationDate()));
        } catch (DatatypeConfigurationException dce) {
            enterpriseGroupDTO.setCreationDate(null);
        }

        if (enterpriseGroup.getDepartments() != null) {
            for (EnterpriseGroupDepartment dep : enterpriseGroup.getDepartments()) {
                enterpriseGroupDTO.getDepartments().add(EnterpriseGroupDepartmentMounter.mountTransferObject(dep, enterpriseGroupDTO));
            }
        }

        if (enterpriseGroup.getFunctions() != null) {
            for (EnterpriseGroupFunction func : enterpriseGroup.getFunctions()) {
                enterpriseGroupDTO.getFunctions().add(EnterpriseGroupFunctionMounter.mountTransferObject(func, enterpriseGroupDTO));
            }
        }

        if (enterpriseGroup.getOccupations() != null) {
            for (EnterpriseGroupOccupation occu : enterpriseGroup.getOccupations()) {
                enterpriseGroupDTO.getOccupations().add(EnterpriseGroupOccupationMounter.mountTransferObject(occu, enterpriseGroupDTO));
            }
        }

        return enterpriseGroupDTO;        
    }
    
    /**
     * Monta um grupo corporativo a partir de um grupo corporativo de transfncia.
     * 
     * @param enterpriseGroupDTO Grupo corporativo de transferncia.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Grupo corporativo
     */
    public static EnterpriseGroup mountLocalObject(EnterpriseGroupDTO enterpriseGroupDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        EnterpriseGroup enterpriseGroup = new EnterpriseGroup();
        
        enterpriseGroup.setUid(enterpriseGroupDTO.getUid());
        enterpriseGroup.setId(enterpriseGroupDTO.getId());
        enterpriseGroup.setCreationDate(DateMounter.mountLocalObject(enterpriseGroupDTO.getCreationDate()));
        enterpriseGroup.setUserType(EnterpriseGroupUserTypeMounter.mountLocalObject(enterpriseGroupDTO.getUserType()));
        enterpriseGroup.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(
        		enterpriseGroupDTO.getApplicationEnvironment(), preferredUserLanguage));
        enterpriseGroup.setArea(AreaMounter.mountLocalObject(enterpriseGroupDTO.getArea(), preferredUserLanguage, 
        		supportedApplicationLanguages));
        
        enterpriseGroup.setExpiration(ExpirationMounter.mountLocalObject(enterpriseGroupDTO.getExpiration()));
        enterpriseGroup.setApplicationEnvironment(ApplicationEnvironmentMounter.mountLocalObject(enterpriseGroupDTO.getApplicationEnvironment(), preferredUserLanguage));
        
        // I18n
        enterpriseGroup.setNameTranslations(I18nStringMounter.mountModelObject(enterpriseGroupDTO.getNameTranslations(), preferredUserLanguage, supportedApplicationLanguages));
        enterpriseGroup.setDescriptionTranslations(I18nStringMounter.mountModelObject(enterpriseGroupDTO.getDescriptionTranslations(), preferredUserLanguage, supportedApplicationLanguages));

        if (enterpriseGroupDTO.getDepartments() != null) {
            for (EnterpriseGroupDepartmentDTO dep : enterpriseGroupDTO.getDepartments()) {
                enterpriseGroup.getDepartments().add(EnterpriseGroupDepartmentMounter.mountLocalObject(dep, enterpriseGroup));
            }
        }

        if (enterpriseGroupDTO.getFunctions() != null) {
            for (EnterpriseGroupFunctionDTO func : enterpriseGroupDTO.getFunctions()) {
                enterpriseGroup.getFunctions().add(EnterpriseGroupFunctionMounter.mountLocalObject(func, enterpriseGroup));
            }
        }

        if (enterpriseGroupDTO.getOccupations() != null) {
            for (EnterpriseGroupOccupationDTO occu : enterpriseGroupDTO.getOccupations()) {
                enterpriseGroup.getOccupations().add(EnterpriseGroupOccupationMounter.mountLocalObject(occu, enterpriseGroup));
            }
        }

        return enterpriseGroup;
    }

}
