/*
 * ExpirationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.Expiration;
import br.com.petrobras.security.server.service.soap.ExpirationDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador de expiraes.
 * 
 * @author JGTL.
 */
public class ExpirationMounter {

    /**
     * Monta uma expirao a partir de uma expirao de transferncia.
     * 
     * @param expirationDTO
     *            Expirao de transferncia.
     * @return Expirao.
     */
    public static Expiration mountLocalObject(ExpirationDTO expirationDTO) {
        if (expirationDTO == null) {
            return null;
        } else {
            Expiration expiration = new Expiration();

            expiration.setUid(expirationDTO.getUid());
            expiration.setStart(DateMounter.mountLocalObject(expirationDTO
                    .getStart()));
            expiration.setEnd(DateMounter.mountLocalObject(expirationDTO
                    .getEnd()));
            expiration.setCreationDate(DateMounter
                    .mountLocalObject(expirationDTO.getCreationDate()));

            return expiration;
        }
    }

    // / <summary>
    // / Monta uma expirao de transferncia a partir de um expirao.
    // / </summary>
    // / <param name="expiration">Expirao.</param>
    // / <returns>Expirao de transferncia.</returns>
    public static ExpirationDTO mountTransferObject(Expiration expiration) {
        if (expiration == null) {
            return null;
        } else {
            ExpirationDTO expirationDTO = new ExpirationDTO();

            expirationDTO.setUid(expiration.getUid());

            try {
                expirationDTO.setStart(DateMounter
                        .mountTransferObject(expiration.getStart()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de incio da expirao para enviar ao servio. "
                                + dtce.getMessage());
            }

            try {
                expirationDTO.setEnd(DateMounter.mountTransferObject(expiration
                        .getEnd()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de trmino da expirao para enviar ao servio. "
                                + dtce.getMessage());
            }

            try {
                expirationDTO.setCreationDate(DateMounter
                        .mountTransferObject(expiration.getCreationDate()));
            } catch (DatatypeConfigurationException dtce) {
                throw new InvalidOperationException(
                        "No foi possvel converter a data de cadastro da expirao para enviar ao servio. "
                                + dtce.getMessage());
            }
            return expirationDTO;
        }

    }

}

