 /*
 * ExternalUserListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.ExternalUser;
 import br.com.petrobras.security.server.service.soap.ExternalUserDTO;

 import java.util.ArrayList;
 import java.util.List;

/**
 * Montador da lista de usurios.
 * 
 * @author Patrezze - ympd
 * @since 3.0
 * @version 1.0
 */
public class ExternalUserListMounter {

    /**
     * Monta uma lista de usurios externo a partir de uma lista de usurios de transferncia.
     * 
     * @param externalUserDTOList Lista de usurios externos de transferncia.
     * @return Lista de usurios externos.
     */
    public static List<ExternalUser> mountModelObject(List<Object> externalUserDTOList) {
        if (externalUserDTOList == null) { return null; }
        
        List<ExternalUser> externalUserList = new ArrayList<ExternalUser>();
        
        for (Object objectExternalUserDTO : externalUserDTOList) {
            ExternalUserDTO externalUserDTO = (ExternalUserDTO) objectExternalUserDTO;
            externalUserList.add(ExternalUserMounter.mountModelObject(externalUserDTO));
        }
        return externalUserList;
    }
}
