/*
 * ExternalUserMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.ExternalUser;
import br.com.petrobras.security.server.service.soap.ExternalUserDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * @author Rodrigo Carvalho - UPM7
 *
 */
public class ExternalUserMounter {
    
    public static ExternalUser mountModelObject (ExternalUserDTO externalDTO) {
        if (externalDTO == null) { return null; }
    
        ExternalUser external = new ExternalUser();
        mountModelObject(externalDTO, external);
    
        return external;
    }

    static void mountModelObject(ExternalUserDTO externalDTO, ExternalUser external) {
        UserMounter.mountModelObject(externalDTO, external);
    
        external.setDocumentNumber(externalDTO.getDocumentNumber());
        external.setPhoneNumber(externalDTO.getPhoneNumber());
        external.setCellphoneNumber(externalDTO.getCellphoneNumber());
        external.setAddress(externalDTO.getAddress());
        external.setZipCodeAddress(externalDTO.getZipCodeAddress());
        external.setDistrictAddress(externalDTO.getDistrictAddress());
        external.setCityAddress(externalDTO.getCityAddress());
        external.setStateAddress(externalDTO.getStateAddress());
        external.setCountryAddress(externalDTO.getCountryAddress());
        
        external.setBirthDate(DateMounter.mountLocalObject(externalDTO.getBirthDate()));
    
        external.setGender(GenderMounter.MountModelObject(externalDTO.getGender()));
    }

    public static ExternalUserDTO mountTransferObject (ExternalUser external) {
        if (external == null)
        {
            return null;
        }
    
        ExternalUserDTO externalDTO = new ExternalUserDTO();
        mountTransferObject(external, externalDTO);
    
        return externalDTO;
    }

    static void mountTransferObject(ExternalUser external, ExternalUserDTO externalDTO) {
        UserMounter.mountTransferObject(external, externalDTO);
    
        externalDTO.setDocumentNumber(external.getDocumentNumber());
        externalDTO.setPhoneNumber(external.getPhoneNumber());
        externalDTO.setCellphoneNumber(external.getCellphoneNumber());
        externalDTO.setAddress(external.getAddress());
        externalDTO.setZipCodeAddress(external.getZipCodeAddress());
        externalDTO.setDistrictAddress(external.getDistrictAddress());
        externalDTO.setCityAddress(external.getCityAddress());
        externalDTO.setStateAddress(external.getStateAddress());
        externalDTO.setCountryAddress(external.getCountryAddress());
        try {
            externalDTO.setBirthDate(DateMounter.mountTransferObject(external.getBirthDate()));
        } catch (DatatypeConfigurationException dtce) {
            throw new InvalidOperationException(
                    "No foi possvel converter a data de cadastro do departamento para enviar ao servio. "
                            + dtce.getMessage());
        }
    
        externalDTO.setGender(GenderMounter.MountTransferObject(external.getGender()));
    }

}
