package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.model.log.LogAuthentication;
import br.com.petrobras.security.server.service.soap.AuthenticationTypeDTO;
import br.com.petrobras.security.server.service.soap.EventTypeDTO;
import br.com.petrobras.security.server.service.soap.LogAuthenticationDTO;
import br.com.petrobras.security.server.service.soap.StatusTypeDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Realiza para a classe LogAuthentication a conversao entre objetos de transferencia e objetos locais
 *
 */
public class LogAuthenticationMounter {

    /**
     * Monta um LogAuthentication do modelo local a partir de um LogAuthentication de transferencia.
     * @param logAuthenticationDTO
     * @return
     */
    public static LogAuthentication mountLocalObject(LogAuthenticationDTO logAuthenticationDTO) {

        if (logAuthenticationDTO == null) {
            return null;
        }

        LogAuthentication logAuhtentication = new LogAuthentication();

        logAuhtentication.setEventType(mountEventTypeModelObject(logAuthenticationDTO.getEventType()));
        logAuhtentication.setAuthenticationType(mountAuthenticationTypeModelObject(logAuthenticationDTO.getAuthenticationType()));
        logAuhtentication.setCreationDate(DateMounter.mountLocalObject(logAuthenticationDTO.getCreationDate()));
        logAuhtentication.setUserLogin(logAuthenticationDTO.getUserLogin());
        logAuhtentication.setStatusType(mountStatusTypeModelObject(logAuthenticationDTO.getStatus()));

        return logAuhtentication;
    }

    /**
     * Monta um LogAuthentication de transferencia a partir de LogAuthentication do modelo local.
     * @param logAuthentication
     * @return
     */
    public static LogAuthenticationDTO  mountTransferObject(LogAuthentication logAuthentication) {

        if (logAuthentication == null) {
            return null;
        }

        LogAuthenticationDTO  logAuthenticationDTO= new LogAuthenticationDTO();

        logAuthenticationDTO.setEventType(mountEventTypeTransferObject(logAuthentication.getEventType()));
        logAuthenticationDTO.setAuthenticationType(mountAuthenticationTypeTransferObject(logAuthentication.getAuthenticationType()));

        try {
            logAuthenticationDTO.setCreationDate(DateMounter.mountTransferObject(logAuthentication.getCreationDate()));
        } catch (DatatypeConfigurationException dtce) {
            throw new InvalidOperationException(
                    "No foi possvel converter a data de criacao do log  para enviar ao servio. "
                            + dtce.getMessage());

        }

        logAuthenticationDTO.setUserLogin(logAuthentication.getUserLogin());
        logAuthenticationDTO.setStatus(mountStatusTypeTransferObject(logAuthentication.isStatus()));

        return logAuthenticationDTO;
    }

    /**
     * Monta um tipo de evento do modelo a partir de um de evento de transferencia.
     *
     * @param eventTypeDTO
     *            evendo de autenticacao de transferencia.
     * @return Estado de lotao do modelo.
     */
    public static LogAuthentication.EventType mountEventTypeModelObject(EventTypeDTO eventTypeDTO) {

        if (eventTypeDTO == null){
            return null;
        }

        switch (eventTypeDTO) {
            case LOGIN:
                return LogAuthentication.EventType.LOGIN;
            case LOGOFF:
                return LogAuthentication.EventType.LOGOFF;
            default:
                return null;
        }

    }

    /**
     * Monta um tipo de evento de transferencia a partir de um evento do modelo.
     *
     * @param status
     *            evento de autenticacao do modelo.
     * @return Estado de lotao de transferencia.
     */
    public static EventTypeDTO mountEventTypeTransferObject(LogAuthentication.EventType status) {

        if (status == null){
            return EventTypeDTO.UNDEFINED;
        }

        switch (status) {
            case LOGIN:
                return EventTypeDTO.LOGIN;
            default:
                return EventTypeDTO.LOGOFF;
        }
    }

    /**
     * Monta um tipo de autenticacao do modelo a partir de um de um tipo de autenticacao de transferencia.
     *
     * @param authenticationTypeDTO
     *            evento de autenticacao de transferencia.
     * @return evento de autenticacao do modelo.
     */
    public static LogAuthentication.AuthenticationType mountAuthenticationTypeModelObject(AuthenticationTypeDTO authenticationTypeDTO) {

        if (authenticationTypeDTO == null){
            return null;
        }

        switch (authenticationTypeDTO) {
            case AD:
                return LogAuthentication.AuthenticationType.AD;
            case INTEGRATED:
                return LogAuthentication.AuthenticationType.INTEGRATED;
            case EXTERNAL_USER:
                return LogAuthentication.AuthenticationType.EXTERNAL_USER;
            case SSO:
                return LogAuthentication.AuthenticationType.SSO;
            case LOGOFF:
                return LogAuthentication.AuthenticationType.LOGOFF;
            default:
                return null;
        }

    }

    /**
     * Monta um tipo de evento de transferencia a partir de um evento do modelo.
     *
     * @param authenticationType
     *            evento de autenticacao do modelo.
     * @return evento de autenticacao do transferencia.
     */
    public static AuthenticationTypeDTO mountAuthenticationTypeTransferObject(LogAuthentication.AuthenticationType authenticationType) {

        if (authenticationType == null){
            return AuthenticationTypeDTO.UNDEFINED;
        }

        switch (authenticationType) {
            case AD:
                return AuthenticationTypeDTO.AD;
            case INTEGRATED:
                return AuthenticationTypeDTO.INTEGRATED;
            case EXTERNAL_USER:
                return AuthenticationTypeDTO.EXTERNAL_USER;
            case SSO:
                return AuthenticationTypeDTO.SSO;
            default:
                return AuthenticationTypeDTO.LOGOFF;
        }
    }


    /**
     * Monta um status de autenticacao do modelo a partir de um de um status de autenticacao de transferencia.
     *
     * @param statusTypeDTO
     *            status de autenticacao de transferencia.
     * @return stats de autenticacao do modelo.
     */
    public static LogAuthentication.StatusType mountStatusTypeModelObject(StatusTypeDTO statusTypeDTO) {

        if (statusTypeDTO == null){
            return null;
        }

        switch (statusTypeDTO) {
            case SUCCESS:
                return LogAuthentication.StatusType.SUCCESS;
            case FAIL:
                return LogAuthentication.StatusType.FAIL;
            default:
                return null;
        }

    }

    /**
     * Monta um status de transferencia a partir de um status do modelo.
     *
     * @param statusType
     *            status de autenticacao de transferencia.
     * @return status de autenticacao do modelo.
     */
    public static StatusTypeDTO mountStatusTypeTransferObject(LogAuthentication.StatusType statusType) {

        if (statusType == null){
            return StatusTypeDTO.UNDEFINED;
        }

        switch (statusType) {
            case SUCCESS:
                return StatusTypeDTO.SUCCESS;
            default:
                return StatusTypeDTO.FAIL;
        }
    }



}
