 /*
 * OccupationListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.Occupation;
 import br.com.petrobras.security.server.service.soap.OccupationDTO;

 import java.util.ArrayList;
 import java.util.List;

/**
 * Montador de lista de cargos de empregados.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class OccupationListMounter {

    /**
     * Monta uma lista de cargos de empregados a partir de uma lista de cargos
     * de empregados de transferncia.
     * 
     * @param occupationListDTO Lista de cargos de empregados de transferncia.
     * @return Lista de cargos de empregados
     */
    public static List<Occupation> mountLocalObject(
            List<Object> occupationListDTO) {
        if (occupationListDTO == null) {
            return null;
        }

        List<Occupation> occupationList = new ArrayList<Occupation>();

        for (Object objectOccupationDTO : occupationListDTO) {
            OccupationDTO occupationDTO = (OccupationDTO) objectOccupationDTO;
            occupationList.add(OccupationMounter
                    .mountLocalObject(occupationDTO));
        }

        return occupationList;
    }

}
