 /*
 * OccupationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Occupation;
import br.com.petrobras.security.server.service.soap.OccupationDTO;

/**
 * Montador de cargo de empregado.
 * 
 * @author Eraldo Neto - HMGL
 * @since 3.0
 * @version 1.0
 * 
 */
public class OccupationMounter {

    /**
     * Monta um cargo de empregado do modelo a partir de uma cargo de empregado de transferncia.
     * 
     * @param occupationDTO
     *            Cargo de empregado de transferncia.
     * @return Cargo de empregado do modelo.
     */
    public static Occupation mountLocalObject(OccupationDTO occupationDTO) {
        if (occupationDTO == null) {
            return null;
        }

        Occupation occupation = new Occupation();

        occupation.setCode(occupationDTO.getCode());
        occupation.setName(occupationDTO.getName());
        occupation.setDescription(occupationDTO.getDescription());
        
        return occupation;
    }

    /**
     * Monta um cargo de empregado de transferncia a partir de um cargo de empregado do modelo.
     * 
     * @param occupation
     *            Cargo de empregado do modelo.
     * @return Cargo de empregado de transferncia.
     */
    public static OccupationDTO mountTransferObject(Occupation occupation) {
        if (occupation == null) {
            return null;
        }

        OccupationDTO occupationDTO = new OccupationDTO();
        occupationDTO.setCode(occupation.getCode());
        occupationDTO.setName(occupation.getName());
        occupationDTO.setDescription(occupation.getDescription());
        
        return occupationDTO;
    }
}
